/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.ippstack;

import com.xerox.ippstack.CertificateAccess;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import sun.security.x509.X500Name;

public class SessionCertificate
implements CertificateAccess {
    private static final char[] TOHEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private X509Certificate cert;
    private boolean validDate = true;
    private boolean validName = true;
    private String peer;

    private static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int i2 = 0;
        int j2 = 0;
        while (i2 < bytes.length) {
            chars[j2++] = TOHEX[bytes[i2] >> 4 & 0xF];
            chars[j2++] = TOHEX[bytes[i2] & 0xF];
            ++i2;
        }
        return new String(chars);
    }

    private String getCertFingerPrint(String mdAlg) throws Exception {
        byte[] encCertInfo = this.cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(mdAlg);
        byte[] digest = md.digest(encCertInfo);
        return SessionCertificate.toHexString(digest);
    }

    public boolean isCertPeerValid() {
        return this.validName;
    }

    public boolean isCertDateValid() {
        this.validDate = true;
        try {
            this.cert.checkValidity();
        }
        catch (CertificateExpiredException ex) {
            this.validDate = false;
            return false;
        }
        catch (CertificateNotYetValidException ny) {
            this.validDate = false;
            return false;
        }
        return this.validDate;
    }

    public String getSHA1Fingerprint() throws Exception {
        return this.getCertFingerPrint("SHA1");
    }

    public String getMD5Fingerprint() throws Exception {
        return this.getCertFingerPrint("MD5");
    }

    public String getPeerHostName() {
        return this.peer;
    }

    public String getSerialNumber() {
        return this.cert.getSerialNumber().toString(16);
    }

    public String getNotBefore() {
        return this.cert.getNotBefore().toString();
    }

    public String getNotAfter() {
        return this.cert.getNotAfter().toString();
    }

    public String getIssuerDN() {
        return this.cert.getIssuerDN().toString();
    }

    public String getSubjectDN() {
        return this.cert.getSubjectDN().toString();
    }

    SessionCertificate(X509Certificate certificate, String peerName, boolean testPeer) {
        this.cert = certificate;
        this.peer = peerName;
        if (!testPeer) {
            return;
        }
        try {
            String canonicalName = InetAddress.getByName(this.peer).getCanonicalHostName();
            String certDN = this.getSubjectDN();
            X500Name name = new X500Name(certDN);
            this.validName = canonicalName.equalsIgnoreCase(name.getCommonName());
        }
        catch (Exception e2) {
            this.validName = false;
        }
    }
}

