/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.IppUtil;

public class IppStatusCode {
    protected static final int RANGE_LENGTH = 255;
    protected static final int SUCCESSFULL = 0;
    protected static final String SUCCESSFULL_NAME = "successful";
    protected static final String SUCCESSFULL_INFO = "The action was successfully received, understood, and accepted";
    protected static final int INFORMATIONAL = 256;
    protected static final String INFORMATIONAL_NAME = "informational";
    protected static final String INFORMATIONAL_INFO = "request received, continue process";
    protected static final int REDIRECTION = 512;
    protected static final String REDIRECTION_NAME = "redirection";
    protected static final String REDIRECTION_INFO = "futher action must be taken in order to complete the request";
    protected static final int CLIENT_ERROR = 1024;
    protected static final String CLIENT_ERROR_NAME = "client-error";
    protected static final String CLIENT_ERROR_INFO = "the request contains bad syntax or cannot be filled";
    protected static final int SERVER_ERROR = 1280;
    protected static final String SERVER_ERROR_NAME = "server-error";
    protected static final String SERVER_ERROR_INFO = "the Ipp object failed to fulfill an apparently valid request";
    protected static final int OUT_OF_RANGE = 1536;
    protected static final String OUT_OF_RANGE_NAME = "out-of-range";
    protected static final String OUT_OF_RANGE_INFO = "Error - returned status code not within defined Ipp Range";
    protected static final String IPP_RANGE_LABEL = "Ipp Status Code Range is - ";
    private int ippStatusCodeRange;
    private String ippStatusCodeRangeName;
    private String ippStatusCodeRangeInfo;
    protected String ippStatusCodeMsg;
    private int statusCode;
    private boolean successfull;

    public IppStatusCode(int n) {
        this.statusCode = n;
        this.statusCodeMsg(n);
    }

    public String getHexStatusCode() {
        return "0x" + Integer.toHexString(this.statusCode);
    }

    public String getStatusCodeMsg() {
        return this.ippStatusCodeMsg;
    }

    private void statusCodeMsg(int n) {
        this.successfull = false;
        switch (n) {
            case 0: {
                this.ippStatusCodeMsg = "successful-ok";
                this.successfull = true;
                break;
            }
            case 1: {
                this.ippStatusCodeMsg = "successful-ok-ignored-or-substituted-attributes";
                this.successfull = true;
                break;
            }
            case 2: {
                this.ippStatusCodeMsg = "successful-ok-conflicting-attributes";
                this.successfull = true;
                break;
            }
            case 3: {
                this.ippStatusCodeMsg = "successful-ok-ignored-subscriptions";
                this.successfull = true;
                break;
            }
            case 4: {
                this.ippStatusCodeMsg = "successful-ok-ignored-notifications";
                this.successfull = true;
                break;
            }
            case 5: {
                this.ippStatusCodeMsg = "successful-ok-too-many-events";
                this.successfull = true;
                break;
            }
            case 6: {
                this.ippStatusCodeMsg = "successful-ok-but-cancel-subscription";
                this.successfull = true;
                break;
            }
            case 1024: {
                this.ippStatusCodeMsg = "client-error-bad-request";
                break;
            }
            case 1025: {
                this.ippStatusCodeMsg = "client-error-forbidden";
                break;
            }
            case 1026: {
                this.ippStatusCodeMsg = "client-error-not-authorized";
                break;
            }
            case 1027: {
                this.ippStatusCodeMsg = "client-error-not-authenticated";
                break;
            }
            case 1028: {
                this.ippStatusCodeMsg = "client-error-not-possible";
                break;
            }
            case 1029: {
                this.ippStatusCodeMsg = "client-error-timeout";
                break;
            }
            case 1030: {
                this.ippStatusCodeMsg = "client-error-not-found";
                break;
            }
            case 1031: {
                this.ippStatusCodeMsg = "client-error-gone";
                break;
            }
            case 1032: {
                this.ippStatusCodeMsg = "client-error-request-entity-too-large";
                break;
            }
            case 1033: {
                this.ippStatusCodeMsg = "client-error-request-value-too-long";
                break;
            }
            case 1034: {
                this.ippStatusCodeMsg = "client-error-document-format-not-supported";
                break;
            }
            case 1035: {
                this.ippStatusCodeMsg = "client-error-attributes-or-values-not-supported";
                break;
            }
            case 1036: {
                this.ippStatusCodeMsg = "client-error-uri-scheme-not-supported";
                break;
            }
            case 1037: {
                this.ippStatusCodeMsg = "client-error-charset-not-supported";
                break;
            }
            case 1038: {
                this.ippStatusCodeMsg = "client-error-conflicting-attributes";
                break;
            }
            case 1039: {
                this.ippStatusCodeMsg = "client-error-compression-not-supported";
                break;
            }
            case 1040: {
                this.ippStatusCodeMsg = "client-error-compression-error";
                break;
            }
            case 1041: {
                this.ippStatusCodeMsg = "client-error-document-format-error";
                break;
            }
            case 1042: {
                this.ippStatusCodeMsg = "client-error-document-access-error";
                break;
            }
            case 1043: {
                this.ippStatusCodeMsg = "client-error-attributes-not-settable";
                break;
            }
            case 1044: {
                this.ippStatusCodeMsg = "client-error-ignored-all-subscriptions";
                break;
            }
            case 1045: {
                this.ippStatusCodeMsg = "client-error-too-many-subscriptions";
                break;
            }
            case 1280: {
                this.ippStatusCodeMsg = "server-error-internal-error";
                break;
            }
            case 1281: {
                this.ippStatusCodeMsg = "server-error-operation-not-supported";
                break;
            }
            case 1282: {
                this.ippStatusCodeMsg = "server-error-service-unavailable";
                break;
            }
            case 1283: {
                this.ippStatusCodeMsg = "server-error-version-not-supported";
                break;
            }
            case 1284: {
                this.ippStatusCodeMsg = "server-error-device-error";
                break;
            }
            case 1285: {
                this.ippStatusCodeMsg = "server-error-temporary-error";
                break;
            }
            case 1286: {
                this.ippStatusCodeMsg = "server-error-not-accepting-jobs";
                break;
            }
            case 1287: {
                this.ippStatusCodeMsg = "server-error-busy";
                break;
            }
            case 1288: {
                this.ippStatusCodeMsg = "server-error-job-canceled";
                break;
            }
            case 1289: {
                this.ippStatusCodeMsg = "server-error-multiple-document-jobs-not-supported";
                break;
            }
            case 1290: {
                this.ippStatusCodeMsg = "server-error-printer-is-deactivated";
                break;
            }
            default: {
                this.ippStatusCodeMsg = "client-error-xxx-yyy";
            }
        }
    }

    protected void setIppStatusCodeRange(int n) {
        if (n >= 0 && n < 256) {
            this.ippStatusCodeRange = 0;
            this.ippStatusCodeRangeName = SUCCESSFULL_NAME;
            this.ippStatusCodeRangeInfo = SUCCESSFULL_INFO;
        } else if (n >= 256 && n < 512) {
            this.ippStatusCodeRange = 256;
            this.ippStatusCodeRangeName = INFORMATIONAL_NAME;
            this.ippStatusCodeRangeInfo = INFORMATIONAL_INFO;
        } else if (n >= 512 && n < 1024) {
            this.ippStatusCodeRange = 512;
            this.ippStatusCodeRangeName = REDIRECTION_NAME;
            this.ippStatusCodeRangeInfo = REDIRECTION_INFO;
        } else if (n >= 1024 && n < 1280) {
            this.ippStatusCodeRange = 1024;
            this.ippStatusCodeRangeName = CLIENT_ERROR_NAME;
            this.ippStatusCodeRangeInfo = CLIENT_ERROR_INFO;
        } else if (n >= 1280 && n < 1536) {
            this.ippStatusCodeRange = 1280;
            this.ippStatusCodeRangeName = SERVER_ERROR_NAME;
            this.ippStatusCodeRangeInfo = SERVER_ERROR_INFO;
        } else {
            this.ippStatusCodeRange = 1280;
            this.ippStatusCodeRangeName = SERVER_ERROR_NAME;
            this.ippStatusCodeRangeInfo = SERVER_ERROR_INFO;
        }
    }
}

