/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.IppUtil;

import com.xerox.IppOps.AttributeType;
import com.xerox.IppOps.IppSyntax;
import com.xerox.IppOps.iAttribute;
import com.xerox.IppOps.iAttributeGroup;
import com.xerox.IppOps.iCollectionValue;
import com.xerox.IppOps.iSimpleIterator;
import com.xerox.IppOps.iValueElement;
import com.xerox.IppUtil.iDataOutputWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;

public class DataOutputWriter
implements iDataOutputWriter {
    public static final int NAME_ONLY = 0;
    public static final int NAME_AND_VALUE = 1;
    public static final String EMPTY_STRING = "";
    private static final String DASH_BAR_60 = "------------------------------------------------------------";
    private FileWriter fw = null;
    private BufferedWriter bw = null;
    private PrintWriter pw = null;
    private File file = null;
    OutputStream out = null;
    private FileWriter fw_SL = null;
    private BufferedWriter bw_SL = null;
    private PrintWriter pw_SL = null;
    private File file_SL = null;
    private String sMediaKey = "null";
    private String sCustomX = "CustomX=";
    private String sCustomY = "CustomY=";
    private String sColorName = "ColorXpdKeyword=";
    private String sCustomColor = "CustomColor=";
    private String sMediaType = "TypeXpdKeyword=";
    private String sMediaTypeName = "null";
    private String sCustomType = "CustomType=";
    private String sPunch = "PunchXpdKeyword=";
    private String NUM_IN_SEQ = "NumberInSequence=";
    private String sWeight = "WeightXpdKeywordOrGsm=";
    private String sBackCoating = "null";
    private String sFrontCoating = "null";
    private String sSidesCoated = "SidesCoatedXpdKeyword=OpSCKeyPrinterDefault";
    private String sCoatingType = "CoatingTypeXpdKeyword=OpKeyGloss";
    private String sDescription = "Description=";
    private String sComment = "Comment=";
    private String sPrinterName = "";
    private String sOutputBuffer = "";
    private int iMainList = 0;
    private static final String DEFINED_BY_NAME = "DefinedByNameOnly=0";
    private static final String MEDIA_SIZE = "SizeXpdKeyword=CustomPaperSizePsDocSticky";
    private static final String CUSTOM_SIZE_UNIT = "CustomSizeUnit=OpKeyInches";
    private static final String CUSTOM_COLOR = "ColorXpdKeyword=OpKeyCustom";
    private static final String CUSTOM_TYPE = "TypeXpdKeyword=OpKeyCustom";
    private static final String UNCOATED_FINISH = "UncoatedFinishXpdKeyword=OpKeyPrinterDefault";
    private static final String GRAIN = "GrainXpdKeyword=OpKeyPrinterDefault";
    private static final String USER_SELECTED = "UserSelected=no";
    private int ithread = 0;
    private boolean bValidMediaName = true;

    public DataOutputWriter(OutputStream outputStream) {
        this.out = this.out;
        try {
            this.pw = new PrintWriter(outputStream);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public DataOutputWriter(File file) {
        try {
            this.file = file;
            this.fw = new FileWriter(file);
            this.bw = new BufferedWriter(this.fw);
            this.pw = new PrintWriter(this.bw);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public void printContent(iAttributeGroup iAttributeGroup2, int n) {
        this.printContent(iAttributeGroup2, n, null);
    }

    public void printContent(iAttributeGroup iAttributeGroup2, int n, String string) {
        OutputState outputState = new OutputState();
        outputState.setDisplayContent(n);
        if (string != null) {
            outputState.setGroupInfo(string);
        }
        this.printMyAttributeGroup(iAttributeGroup2, outputState, false);
    }

    public void printAttributeNameList(iAttributeGroup iAttributeGroup2) {
        this.pw.println();
        this.pw.println("Attribute Group Type = " + iAttributeGroup2);
        String[] stringArray = iAttributeGroup2.getListOfAttributeNames();
        int n = Array.getLength(stringArray);
        this.pw.println("Attr List size = " + n);
        for (int i = 0; i < n; ++i) {
            this.pw.println(" - " + stringArray[i]);
        }
        this.pw.println();
    }

    public void print(String string) {
        this.pw.print(string);
    }

    public void print(int n) {
        this.pw.print(n);
    }

    public void println() {
        this.pw.println();
    }

    public void println(String string) {
        this.pw.println(string);
    }

    public void println(int n) {
        this.pw.println(n);
    }

    public void flush() {
        this.pw.flush();
    }

    public void close() {
        try {
            this.pw.flush();
            this.pw.close();
            this.bw.close();
            this.fw.close();
        }
        catch (Exception exception) {
            this.pw.println(exception.toString());
        }
    }

    private void printAttributeContents(iAttribute iAttribute2, OutputState outputState) {
        if (iAttribute2 == null) {
            return;
        }
        String string = iAttribute2.getName();
        int n = iAttribute2.getAttributeValue().size();
        AttributeType attributeType = iAttribute2.getType();
        this.pw.println(outputState.indent() + "-" + string);
        this.pw.print(outputState.indent() + "  |-Type = " + attributeType);
        if (attributeType.equals(AttributeType.ONE_SET_OF_COLLECTION)) {
            this.pw.println(" (" + n + " Collections)");
            outputState.incOneSetOfCount();
        } else {
            this.pw.println(" (" + n + " Elements)");
        }
        iSimpleIterator iSimpleIterator2 = iAttribute2.getAttributeValue().iterator();
        iValueElement iValueElement2 = null;
        while (iSimpleIterator2.hasNext()) {
            iValueElement2 = (iValueElement)iSimpleIterator2.next();
            if (iValueElement2.getSyntax().equals(IppSyntax.COLLECTION)) {
                this.pw.println(outputState.indent() + "  |-this " + iValueElement2.getSyntax().getName() + " " + iValueElement2.getStringValue());
                this.pw.println(outputState.indent() + "  |");
            } else {
                this.pw.println(outputState.indent() + "  |-" + iValueElement2.getSyntax().getName() + "   Val = " + iValueElement2.getStringValue());
            }
            if (!iValueElement2.getSyntax().equals(IppSyntax.COLLECTION)) continue;
            outputState.incGroupOpenCount();
            iAttributeGroup iAttributeGroup2 = ((iCollectionValue)iValueElement2).getAttributeGroup();
            this.printAttributeGroup(iAttributeGroup2, outputState);
            outputState.decGroupOpenCount();
        }
        if (outputState.oneSetOfCount() > 0 && outputState.oneSetOfFinished()) {
            outputState.decOneSetOfCount();
        }
    }

    private void printAttributeGroup(iAttributeGroup iAttributeGroup2, OutputState outputState) {
        String string = iAttributeGroup2.getName();
        if (outputState.getGroupOpenCount() == 0) {
            this.pw.println(outputState.indent() + DASH_BAR_60);
            if (outputState.getGroupInfo().equals(EMPTY_STRING)) {
                if (string.equals(EMPTY_STRING)) {
                    this.pw.println(outputState.indent() + "   Attr Group Name = " + string);
                } else {
                    this.pw.println(outputState.indent() + "   Attr Group has no name");
                }
            } else {
                this.pw.println(outputState.indent() + "   " + outputState.getGroupInfo());
            }
            this.pw.println(outputState.indent() + "   Attr Group size = " + iAttributeGroup2.size());
            this.pw.println();
        }
        iSimpleIterator iSimpleIterator2 = iAttributeGroup2.iterator();
        int n = 0;
        while (iSimpleIterator2.hasNext()) {
            ++n;
            if (outputState.displayNameOnly()) {
                this.pw.println(outputState.indent() + "-" + (iAttribute)iSimpleIterator2.next());
                continue;
            }
            this.printAttributeContents((iAttribute)iSimpleIterator2.next(), outputState);
            this.pw.println(outputState.indent());
        }
        String string2 = null;
        string2 = outputState.getGroupOpenCount() == 0 ? "-(End of " + iAttributeGroup2 + " Group)" : "-(End of Collection)";
        this.pw.println(outputState.indent() + string2);
    }

    private void printMyAttributeContents(iAttribute iAttribute2, OutputState outputState) {
        if (iAttribute2 == null) {
            return;
        }
        String string = iAttribute2.getName();
        int n = iAttribute2.getAttributeValue().size();
        AttributeType attributeType = iAttribute2.getType();
        if (attributeType.equals(AttributeType.ONE_SET_OF_COLLECTION)) {
            outputState.incOneSetOfCount();
        }
        iSimpleIterator iSimpleIterator2 = iAttribute2.getAttributeValue().iterator();
        iValueElement iValueElement2 = null;
        while (iSimpleIterator2.hasNext()) {
            long l;
            double d;
            double d2;
            double d3;
            String string2;
            iValueElement2 = (iValueElement)iSimpleIterator2.next();
            if (string.equals("media-key")) {
                this.sMediaKey = iValueElement2.getStringValue();
                if (this.sMediaKey.equals(EMPTY_STRING)) {
                    this.bValidMediaName = false;
                } else {
                    this.sMediaKey = "[" + iValueElement2.getStringValue() + "]";
                }
            } else if (string.equals("x-dimension")) {
                int n2 = 0;
                string2 = iValueElement2.getStringValue();
                if (!string2.equals(EMPTY_STRING)) {
                    n2 = Integer.parseInt(string2);
                    d3 = Math.IEEEremainder(n2 /= 10, 254.0);
                    d2 = Math.floor(n2 / 254);
                    if (d3 > 0.0 && d3 < 5.0) {
                        d = d2 * 254.0;
                        l = Math.round(d);
                        this.sCustomX = this.sCustomX + Long.toString(l);
                    } else if (d3 > -5.0 && d3 < 0.0) {
                        d = (d2 += 1.0) * 254.0;
                        l = Math.round(d);
                        this.sCustomX = this.sCustomX + Long.toString(l);
                    } else if (d3 > 121.0 && d3 < 127.0 || d3 > -127.0 && d3 < -121.0) {
                        d = (d2 += 0.5) * 254.0;
                        l = Math.round(d);
                        this.sCustomX = this.sCustomX + Long.toString(l);
                    } else {
                        this.sCustomX = this.sCustomX + Integer.toString(n2);
                    }
                } else {
                    this.sCustomX = this.sCustomX + iValueElement2.getStringValue();
                }
            } else if (string.equals("y-dimension")) {
                int n3 = 0;
                string2 = iValueElement2.getStringValue();
                if (!string2.equals(EMPTY_STRING)) {
                    n3 = Integer.parseInt(string2);
                    d3 = Math.IEEEremainder(n3 /= 10, 254.0);
                    d2 = Math.floor(n3 / 254);
                    if (d3 > 0.0 && d3 < 5.0) {
                        d = d2 * 254.0;
                        l = Math.round(d);
                        this.sCustomY = this.sCustomY + Long.toString(l);
                    } else if (d3 > -5.0 && d3 < 0.0) {
                        d = (d2 += 1.0) * 254.0;
                        l = Math.round(d);
                        this.sCustomY = this.sCustomY + Long.toString(l);
                    } else if (d3 > 122.0 && d3 < 127.0 || d3 > -127.0 && d3 < -122.0) {
                        d = (d2 += 0.5) * 254.0;
                        l = Math.round(d);
                        this.sCustomY = this.sCustomY + Long.toString(l);
                    } else {
                        this.sCustomY = this.sCustomY + Integer.toString(n3);
                    }
                } else {
                    this.sCustomY = this.sCustomY + iValueElement2.getStringValue();
                }
            } else if (string.equals("media-color")) {
                this.sMediaTypeName = iValueElement2.getStringValue();
                if (this.sMediaTypeName.equals(EMPTY_STRING)) {
                    this.sColorName = this.sColorName + "OpKeyPrintDef";
                } else if (this.sMediaTypeName.equals("white")) {
                    this.sColorName = this.sColorName + "OpKeyWhite";
                } else if (this.sMediaTypeName.equals("blue")) {
                    this.sColorName = this.sColorName + "OpKeyBlue";
                } else if (this.sMediaTypeName.equals("yellow")) {
                    this.sColorName = this.sColorName + "OpKeyYellow";
                } else if (this.sMediaTypeName.equals("green")) {
                    this.sColorName = this.sColorName + "OpKeyGreen";
                } else if (this.sMediaTypeName.equals("pink")) {
                    this.sColorName = this.sColorName + "OpKeyPink";
                } else if (this.sMediaTypeName.equals("no-color")) {
                    this.sColorName = this.sColorName + "OpKeyClear";
                } else if (this.sMediaTypeName.equals("ivory")) {
                    this.sColorName = this.sColorName + "OpKeyIvory";
                } else if (this.sMediaTypeName.equals("gray")) {
                    this.sColorName = this.sColorName + "OpKeyGray";
                } else if (this.sMediaTypeName.equals("buff")) {
                    this.sColorName = this.sColorName + "OpKeyBuff";
                } else if (this.sMediaTypeName.equals("goldenrod")) {
                    this.sColorName = this.sColorName + "OpKeyGoldenrod";
                } else if (this.sMediaTypeName.equals("red")) {
                    this.sColorName = this.sColorName + "OpKeyRed";
                } else if (this.sMediaTypeName.equals("orange")) {
                    this.sColorName = this.sColorName + "OpKeyOrange";
                } else if (this.sMediaTypeName.equals("Custom")) {
                    this.sColorName = this.sColorName + "OpKeyCustom";
                } else if (this.sMediaTypeName.equals("custom1")) {
                    this.sColorName = this.sColorName + "OpKeyCustom1";
                } else if (this.sMediaTypeName.equals("custom2")) {
                    this.sColorName = this.sColorName + "OpKeyCustom2";
                } else if (this.sMediaTypeName.equals("custom3")) {
                    this.sColorName = this.sColorName + "OpKeyCustom3";
                } else if (this.sMediaTypeName.equals("custom4")) {
                    this.sColorName = this.sColorName + "OpKeyCustom4";
                } else if (this.sMediaTypeName.equals("custom5")) {
                    this.sColorName = this.sColorName + "OpKeyCustom5";
                } else if (this.sMediaTypeName.equals("custom6")) {
                    this.sColorName = this.sColorName + "OpKeyCustom6";
                } else if (this.sMediaTypeName.equals("custom7")) {
                    this.sColorName = this.sColorName + "OpKeyCustom7";
                } else if (this.sMediaTypeName.equals("other")) {
                    this.sColorName = this.sColorName + "OpKeyOther";
                } else {
                    this.sColorName = this.sColorName + "OpKeyCustom";
                    this.sCustomColor = this.sCustomColor + this.sMediaTypeName;
                }
            } else if (string.equals("media-type")) {
                this.sMediaTypeName = iValueElement2.getStringValue();
                if (this.sMediaTypeName.equals(EMPTY_STRING)) {
                    this.sMediaType = this.sMediaType + "OpKeyPrintDef";
                } else if (this.sMediaTypeName.equals("stationery")) {
                    this.sMediaType = this.sMediaType + "OpKeyPlain";
                } else if (this.sMediaTypeName.equals("transparency")) {
                    this.sMediaType = this.sMediaType + "OpKeyTrans";
                } else if (this.sMediaTypeName.equals("standard")) {
                    this.sMediaType = this.sMediaType + "OpKeyRecycled";
                } else if (this.sMediaTypeName.equals("labels")) {
                    this.sMediaType = this.sMediaType + "OpKeyLabel";
                } else if (this.sMediaTypeName.equals("_HWLABEL_")) {
                    this.sMediaType = this.sMediaType + "OpKeyHWLabel";
                } else if (this.sMediaTypeName.equals("pre-printed")) {
                    this.sMediaType = this.sMediaType + "OpKeyPreprint";
                } else if (this.sMediaTypeName.equals("_PRECUTTAB_")) {
                    this.sMediaType = this.sMediaType + "OpKeyPreCutTab";
                } else if (this.sMediaTypeName.equals("_HWPRECUTTAB_")) {
                    this.sMediaType = this.sMediaType + "OpKeyHWPreCutTab";
                } else if (this.sMediaTypeName.equals("full-cut-tabs")) {
                    this.sMediaType = this.sMediaType + "OpKeyFullCutTab";
                } else if (this.sMediaTypeName.equals("envelope")) {
                    this.sMediaType = this.sMediaType + "OpKeyEnv";
                } else if (this.sMediaTypeName.equals("Ordered")) {
                    this.sMediaType = this.sMediaType + "OpKeyOrderedStock";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else if (this.sMediaTypeName.equals("Custom")) {
                    this.sMediaType = this.sMediaType + "OpKeyCustom";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else if (this.sMediaTypeName.equals("pre-cut-tabs")) {
                    this.sMediaType = this.sMediaType + "OpKeyPreCutTab";
                } else if (this.sMediaTypeName.equals("bond")) {
                    this.sMediaType = this.sMediaType + "OpKeyBond";
                } else if (this.sMediaTypeName.equals("_HEAVYWEIGHT_")) {
                    this.sMediaType = this.sMediaType + "OpKeyHW";
                } else if (this.sMediaTypeName.equals("stationery2")) {
                    this.sMediaType = this.sMediaType + "OpKeyHW2";
                } else if (this.sMediaTypeName.equals("_HEAVYWEIGHT_RELOADED_")) {
                    this.sMediaType = this.sMediaType + "OpKeyHWReloaded";
                } else if (this.sMediaTypeName.equals("_EXTRAHEAVYWEIGHT_")) {
                    this.sMediaType = this.sMediaType + "OpKeyExtraHW";
                } else if (this.sMediaTypeName.equals("_EXTRAHEAVYWEIGHTSIDE2_")) {
                    this.sMediaType = this.sMediaType + "OpKeyExtraHW2";
                } else if (this.sMediaTypeName.equals("_GLOSSY_")) {
                    this.sMediaType = this.sMediaType + "OpKeyLWGlossy";
                } else if (this.sMediaTypeName.equals("_GLOSSYSIDE2_")) {
                    this.sMediaType = this.sMediaType + "OpKeyLWGlossy2";
                } else if (this.sMediaTypeName.equals("_HEAVYGLOSSY_")) {
                    this.sMediaType = this.sMediaType + "OpKeyHWGlossy";
                } else if (this.sMediaTypeName.equals("_HEAVYGLOSSYSIDE2_")) {
                    this.sMediaType = this.sMediaType + "OpKeyHWGlossy2";
                } else if (this.sMediaTypeName.equals("letter-head")) {
                    this.sMediaType = this.sMediaType + "OpKeyLetterhead";
                } else if (this.sMediaTypeName.equals("_PUNCHED_")) {
                    this.sMediaType = this.sMediaType + "OpKeyPunched";
                } else if (this.sMediaTypeName.equals("other")) {
                    this.sMediaType = this.sMediaType + "OpKeyOther";
                } else if (this.sMediaTypeName.equals("custom1")) {
                    this.sMediaType = this.sMediaType + "OpKeyCustom1";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else if (this.sMediaTypeName.equals("custom2")) {
                    this.sMediaType = this.sMediaType + "OpKeyCustom2";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else if (this.sMediaTypeName.equals("custom3")) {
                    this.sMediaType = this.sMediaType + "OpKeyCustom3";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else if (this.sMediaTypeName.equals("custom4")) {
                    this.sMediaType = this.sMediaType + "OpKeyCustom4";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else if (this.sMediaTypeName.equals("custom5")) {
                    this.sMediaType = this.sMediaType + "OpKeyCustom5";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else if (this.sMediaTypeName.equals("custom6")) {
                    this.sMediaType = this.sMediaType + "OpKeyCustom6";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else if (this.sMediaTypeName.equals("custom7")) {
                    this.sMediaType = this.sMediaType + "OpKeyCustom7";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                } else {
                    this.sMediaType = this.sMediaType + "OpKeyCustom";
                    this.sCustomType = this.sCustomType + this.sMediaTypeName;
                }
            } else if (string.equals("media-hole-count")) {
                String string3 = iValueElement2.getStringValue();
                this.sPunch = string3.compareTo("0") > 0 ? this.sPunch + "OpKeyPunchYes" : this.sPunch + "OpKeyPunchNo";
            } else if (string.equals("media-order-count")) {
                this.NUM_IN_SEQ = this.NUM_IN_SEQ + iValueElement2.getStringValue();
            } else if (string.equals("media-weight-metric")) {
                this.sWeight = this.sWeight + iValueElement2.getStringValue();
            } else if (string.equals("media-front-coating")) {
                this.sFrontCoating = iValueElement2.getStringValue();
                if (this.sFrontCoating.equals("glossy")) {
                    this.sFrontCoating = "OpKeyGloss";
                } else if (this.sFrontCoating.equals("high-gloss")) {
                    this.sFrontCoating = "OpKeyHighGloss";
                } else if (this.sFrontCoating.equals("semi-gloss")) {
                    this.sFrontCoating = "OpKeySemiGloss";
                } else if (this.sFrontCoating.equals("satin")) {
                    this.sFrontCoating = "OpKeySatin";
                } else if (this.sFrontCoating.equals("matte")) {
                    this.sFrontCoating = "OpKeyMatte";
                }
            } else if (string.equals("media-back-coating")) {
                this.sBackCoating = iValueElement2.getStringValue();
                if (this.sBackCoating.equals("glossy")) {
                    this.sBackCoating = "OpKeyGloss";
                } else if (this.sBackCoating.equals("high-gloss")) {
                    this.sBackCoating = "OpKeyHighGloss";
                } else if (this.sBackCoating.equals("semi-gloss")) {
                    this.sBackCoating = "OpKeySemiGloss";
                } else if (this.sBackCoating.equals("satin")) {
                    this.sBackCoating = "OpKeySatin";
                } else if (this.sBackCoating.equals("matte")) {
                    this.sBackCoating = "OpKeyMatte";
                }
                if (this.sBackCoating.equals("none") && this.sFrontCoating.equals("none")) {
                    this.sSidesCoated = "SidesCoatedXpdKeyword=OpSCKeyUncoated";
                } else if (this.sBackCoating.equals("none") && !this.sFrontCoating.equals("none")) {
                    this.sSidesCoated = "SidesCoatedXpdKeyword=OpSCKeyOneSided";
                    this.sCoatingType = "CoatingTypeXpdKeyword=" + this.sFrontCoating;
                } else if (this.sFrontCoating.equals("none") && !this.sBackCoating.equals("none")) {
                    this.sSidesCoated = "SidesCoatedXpdKeyword=OpSCKeyOneSided";
                    this.sCoatingType = "CoatingTypeXpdKeyword=" + this.sBackCoating;
                } else if (!this.sFrontCoating.equals("none") && !this.sBackCoating.equals("none")) {
                    this.sSidesCoated = "SidesCoatedXpdKeyword=OpSCKeyTwoSided";
                    this.sCoatingType = "CoatingTypeXpdKeyword=" + this.sFrontCoating;
                }
            } else if (string.equals("media-description")) {
                this.sDescription = this.sDescription + iValueElement2.getStringValue();
            } else if (string.equals("media-info")) {
                this.sComment = this.sComment + iValueElement2.getStringValue();
            } else if (string.equals("printer-name")) {
                this.sPrinterName = iValueElement2.getStringValue();
            } else if (iValueElement2.getSyntax().equals(IppSyntax.COLLECTION)) {
                // empty if block
            }
            if (!iValueElement2.getSyntax().equals(IppSyntax.COLLECTION)) continue;
            outputState.incGroupOpenCount();
            iAttributeGroup iAttributeGroup2 = ((iCollectionValue)iValueElement2).getAttributeGroup();
            this.printMyAttributeGroup(iAttributeGroup2, outputState, true);
            ++this.iMainList;
            outputState.decGroupOpenCount();
        }
        if (outputState.oneSetOfCount() > 0 && outputState.oneSetOfFinished()) {
            outputState.decOneSetOfCount();
        }
    }

    private void printMyAttributeGroup(iAttributeGroup iAttributeGroup2, OutputState outputState, boolean bl) {
        ++this.ithread;
        String string = iAttributeGroup2.getName();
        if (outputState.getGroupInfo() == "Printer Attribute Group") {
            if (outputState.getGroupOpenCount() != 0 || !outputState.getGroupInfo().equals(EMPTY_STRING) || string.equals(EMPTY_STRING)) {
                // empty if block
            }
            iSimpleIterator iSimpleIterator2 = iAttributeGroup2.iterator();
            int n = 0;
            while (iSimpleIterator2.hasNext()) {
                ++n;
                if (outputState.displayNameOnly()) continue;
                this.printMyAttributeContents((iAttribute)iSimpleIterator2.next(), outputState);
            }
            Object var7_7 = null;
        }
        if (bl && this.ithread == 2) {
            this.writeStockLibraryToFile();
        }
        --this.ithread;
    }

    private void writeStockLibraryToFile() {
        if (this.bValidMediaName) {
            this.pw.println(this.sMediaKey);
            this.pw.println(USER_SELECTED);
            this.pw.println(DEFINED_BY_NAME);
            this.pw.println(MEDIA_SIZE);
            this.pw.println(this.sCustomX);
            this.pw.println(this.sCustomY);
            this.pw.println(CUSTOM_SIZE_UNIT);
            this.pw.println(this.sColorName);
            this.pw.println(this.sCustomColor);
            this.pw.println(this.sMediaType);
            this.pw.println(this.sCustomType);
            this.pw.println(this.NUM_IN_SEQ);
            this.pw.println(this.sPunch);
            this.pw.println(this.sWeight);
            this.pw.println(this.sSidesCoated);
            this.pw.println(this.sCoatingType);
            this.pw.println(UNCOATED_FINISH);
            this.pw.println(GRAIN);
            this.pw.println(this.sDescription);
            this.pw.println(this.sComment);
        }
        this.bValidMediaName = true;
        this.sMediaKey = "null";
        this.sCustomX = "CustomX=";
        this.sCustomY = "CustomY=";
        this.sColorName = "ColorXpdKeyword=";
        this.sCustomColor = "CustomColor=";
        this.sMediaType = "TypeXpdKeyword=";
        this.sCustomType = "CustomType=";
        this.sPunch = "PunchXpdKeyword=";
        this.NUM_IN_SEQ = "NumberInSequence=";
        this.sWeight = "WeightXpdKeywordOrGsm=";
        this.sBackCoating = "null";
        this.sFrontCoating = "null";
        this.sSidesCoated = "SidesCoatedXpdKeyword=OpSCKeyPrinterDefault";
        this.sCoatingType = "CoatingTypeXpdKeyword=OpKeyGloss";
        this.sDescription = "Description=";
        this.sComment = "Comment=";
        --this.iMainList;
    }

    class OutputState {
        private int groupOpenCount = 0;
        private boolean nameOnly = true;
        private int oneSetOfCount = 0;
        private String groupInfo = "";
        private int[] colCountWhenSetOfOpenned = new int[25];
        private int displayContent = 0;
        private String[] spaces = new String[]{"|", "|  |", "|  |  |", "|  |  |  |", "|  |  |  |  |", "|  |  |  |  |  |"};

        OutputState() {
        }

        public void setDisplayContent(int n) {
            this.displayContent = n;
            switch (n) {
                case 0: {
                    this.nameOnly = true;
                    break;
                }
                case 1: {
                    this.nameOnly = false;
                    break;
                }
                default: {
                    this.nameOnly = true;
                }
            }
        }

        public int getDisplayContent() {
            return this.displayContent;
        }

        public String indent() {
            return this.spaces[this.groupOpenCount];
        }

        public int getGroupOpenCount() {
            return this.groupOpenCount;
        }

        public void incGroupOpenCount() {
            ++this.groupOpenCount;
        }

        public void decGroupOpenCount() {
            --this.groupOpenCount;
        }

        public boolean displayNameOnly() {
            return this.nameOnly;
        }

        public void setAttrDisplayMode(boolean bl) {
            this.nameOnly = bl;
        }

        public int oneSetOfCount() {
            return this.oneSetOfCount;
        }

        public void incOneSetOfCount() {
            ++this.oneSetOfCount;
            this.colCountWhenSetOfOpenned[this.oneSetOfCount] = this.getGroupOpenCount();
        }

        public void decOneSetOfCount() {
            --this.oneSetOfCount;
        }

        public boolean oneSetOfFinished() {
            return this.getGroupOpenCount() == this.colCountWhenSetOfOpenned[this.oneSetOfCount];
        }

        public void setGroupInfo(String string) {
            this.groupInfo = string;
        }

        public String getGroupInfo() {
            return this.groupInfo;
        }
    }
}

