/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.IppUtil;

import com.xerox.IppOps.iCertificateAccept;
import com.xerox.IppOps.iCertificateInfo;
import com.xerox.IppUtil.DataOutputWriter;
import com.xerox.IppUtil.iDataOutputWriter;
import java.io.File;

public class CertificateAccept
implements iCertificateAccept {
    private iDataOutputWriter dow = null;
    private iCertificateInfo certificateInfo = null;
    private boolean acceptCert = false;

    public CertificateAccept() {
    }

    public CertificateAccept(iDataOutputWriter iDataOutputWriter2) {
        if (iDataOutputWriter2 == null) {
            // empty if block
        }
        this.dow = iDataOutputWriter2;
    }

    public boolean acceptServerCertificate(iCertificateInfo iCertificateInfo2) {
        if (this.dow != null) {
            this.dow.println("Certificate Info:");
            this.dow.println("  Peer Host Name - " + iCertificateInfo2.getPeerHostName());
            this.dow.println("  Subject   Name - " + iCertificateInfo2.getSubjectDN());
            this.dow.println("  Issuer    Name - " + iCertificateInfo2.getIssuerDN());
        }
        this.certificateInfo = iCertificateInfo2;
        this.writeCertificateToFile("certinfo.txt");
        return this.acceptCert;
    }

    public iCertificateInfo getCertificateInfo() {
        return this.certificateInfo;
    }

    private void writeCertificateToFile(String string) {
        File file = new File(string);
        DataOutputWriter dataOutputWriter = new DataOutputWriter(file);
        dataOutputWriter.println("<CertificateInfo>");
        dataOutputWriter.println("  <SubjectDN>" + this.certificateInfo.getSubjectDN() + "</SubjectDN>");
        dataOutputWriter.println("  <PeerHostName>" + this.certificateInfo.getPeerHostName() + "</PeerHostName>");
        dataOutputWriter.println("  <IssuerDN>" + this.certificateInfo.getIssuerDN() + "</IssuerDN>");
        dataOutputWriter.println("  <NotAfter>" + this.certificateInfo.getNotAfter() + "</NotAfter>");
        dataOutputWriter.println("  <NotBefore>" + this.certificateInfo.getNotBefore() + "</NotBefore>");
        dataOutputWriter.println("  <SerialNumber>" + this.certificateInfo.getSerialNumber() + "</SerialNumber>");
        dataOutputWriter.println("  <MD5FingerPrint>" + this.certificateInfo.getMD5Fingerprint() + "</MD5FingerPrint>");
        dataOutputWriter.println("  <SHA1FingerPrint>" + this.certificateInfo.getSHA1Fingerprint() + "</SHA1FingerPrint>");
        dataOutputWriter.println("  <DateIsValid>" + this.certificateInfo.isCertDateValid() + "</DateIsValid>");
        dataOutputWriter.println("  <PeerIsValid>" + this.certificateInfo.isCertPeerValid() + "</PeerIsValid>");
        dataOutputWriter.println("</CertificateInfo>");
        dataOutputWriter.println();
        dataOutputWriter.println("<UsetInputAcceptCert>" + this.acceptCert + "</UsetInputAcceptCert>");
        dataOutputWriter.flush();
        dataOutputWriter.close();
    }

    public void setAcceptance(boolean bl) {
        this.acceptCert = bl;
    }
}

