/*
 * Decompiled with CFR 0.152.
 */
package com.itekus.xcp.cacstar.remote;

import com.itekus.xcp.cacstar.authplugin.CACStarLoginModule;
import com.itekus.xcp.cacstar.protocol.AjaxConnector;
import com.itekus.xcp.cacstar.protocol.CACStarPacket;
import com.itekus.xcp.cacstar.remote.CACStarRemoteServerCommandThread;
import com.itekus.xcp.cacstar.remote.StateHandler;
import java.io.IOException;

public class IdleStateHandler
implements StateHandler {
    private static final String LOCALACCESS = "http://127.0.0.1:8001/xcp/rpc/";
    private static final String CACSTARACCESS = "http://172.19.10.1:8001/WebContent/scripts/";
    private static final String LOGOUT = "logout";
    private static final String CONTENT_TYPE_TEXT = "text/plain;charset=utf-8";
    private static final String CONTENT_TYPE_APPLICATION = "application/x-www-form-urlencoded";
    private static final String CONTENT_TYPE_XML = "text/xml; charset=utf-8";
    private static final String SSMI_LOCAL_ENDPOINT = "http://127.0.0.1/ssm/Management/Local";
    private static final String SSMI_LOGOUT = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" mlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><soap:Body><Logout xmlns=\"http://www.fujixerox.co.jp/2009/01/ssm/management/local\"></Logout></soap:Body></soap:Envelope>";
    private static final String SSMI_LOGOUT_SOAPACTION = "\"http://www.fujixerox.co.jp/2009/01/ssm/management/local#Logout\"";
    private static final String SMI_STATCFG_ENDPOINT = "http://localhost:80/ssm/Management/Anonymous/StatusConfig";
    private static final String SSMI_GETCAP = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n<soap:Body>\n<GetAttribute xmlns=\"http://www.fujixerox.co.jp/2003/12/ssm/management/statusConfig\">\n<Object name=\"urn:fujixerox:names:ssm:1.0:management:printerCapability\">\n<Attribute name=\"ColorMode\" />\n<Attribute name=\"Duplex\" />\n<Attribute name=\"Stacker\" />\n<Attribute name=\"MSI\" />\n</Object>\n</GetAttribute>\n</soap:Body>\n</soap:Envelope>\n";
    private static final String SSMI_GETATTR_SOAPACTION = "\"http://www.fujixerox.co.jp/2003/12/ssm/management/statusConfig#GetAttribute\"";

    public void process(CACStarPacket cACStarPacket, CACStarRemoteServerCommandThread cACStarRemoteServerCommandThread) throws IOException {
        switch (cACStarPacket.getType()) {
            case 2: {
                if (!CACStarLoginModule.isLoggedIn()) break;
                try {
                    System.out.println("Sending logout request to XCP...");
                    String string = AjaxConnector.request(SSMI_LOCAL_ENDPOINT, CONTENT_TYPE_XML, SSMI_LOGOUT_SOAPACTION, SSMI_LOGOUT);
                    System.out.println("done sending logout");
                    System.out.println(string);
                    cACStarRemoteServerCommandThread.sendACK(SSMI_LOCAL_ENDPOINT + string);
                }
                catch (Exception exception) {
                    System.out.println("Exception during logout...");
                    System.out.println(exception.toString() + "::" + exception.getMessage());
                }
                break;
            }
            case 100: {
                System.out.println("General ACK...");
                cACStarRemoteServerCommandThread.sendACK();
            }
        }
    }
}

