/*
 * Decompiled with CFR 0.152.
 */
package com.itekus.xcp.cacstar.remote;

import com.itekus.xcp.cacstar.protocol.CACStarPacket;
import com.itekus.xcp.cacstar.remote.IdleStateHandler;
import com.itekus.xcp.cacstar.remote.StateHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.logging.Logger;

public class CACStarRemoteServerCommandThread
implements Runnable {
    private static Logger logger = Logger.getLogger(CACStarRemoteServerCommandThread.class.getName());
    private static Socket socket;
    private BufferedReader in;
    private BufferedWriter out;
    private boolean running;
    private StateHandler handler;

    public CACStarRemoteServerCommandThread(Socket socket) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        this.handler = new IdleStateHandler();
        this.running = true;
        this.sendACK("Hello world");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.running) {
                CACStarPacket cACStarPacket = new CACStarPacket();
                cACStarPacket.read(this.in);
                this.handler.process(cACStarPacket, this);
            }
        }
        catch (IOException iOException) {
            try {
                this.in.close();
            }
            catch (IOException iOException2) {
                System.out.println("F:" + iOException2.getMessage());
            }
            this.running = false;
            System.out.println("E:" + iOException.getMessage());
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                System.out.println("exception while exiting: " + iOException.getMessage());
            }
            socket = null;
            System.out.println("Exiting Command Server.");
        }
    }

    public void sendACK() throws IOException {
        new CACStarPacket(100, null).write(this.out);
    }

    public void sendACK(Object object) throws IOException {
        new CACStarPacket(100, object).write(this.out);
    }

    public void sendNACK(CACStarPacket cACStarPacket) throws IOException {
        new CACStarPacket(101, null).write(this.out);
    }

    public void stop() {
        this.running = false;
    }

    public void setStateHandler(StateHandler stateHandler) {
        this.handler = stateHandler;
    }
}

