/*
 * Decompiled with CFR 0.152.
 */
package com.itekus.xcp.cacstar.remote;

import com.itekus.xcp.cacstar.remote.CACStarRemoteServerCommandThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.logging.Logger;

public class CACStarRemoteServer {
    private static Logger logger = Logger.getLogger(CACStarRemoteServer.class.getName());
    private static InetAddress remoteIP = null;
    public static final int INCOMING_PORT = 2048;
    public static final int OUTGOING_PORT = 2049;
    private boolean threadcond = true;
    private ServerSocket socket;
    private Thread serverThread;
    private HashMap objectMap = new HashMap();

    public static final InetAddress getRemoteAddress() {
        return remoteIP;
    }

    public void start(int n) throws IOException {
        if (this.socket != null) {
            this.stop();
        }
        if (this.socket == null) {
            this.socket = new ServerSocket(n, 1);
            this.serverThread = new Thread(new CACStarRemoteServerAcceptThread());
            this.serverThread.start();
        }
    }

    public void stop() throws IOException {
        this.threadcond = false;
        if (this.socket != null) {
            this.serverThread = null;
            this.socket.close();
            this.socket = null;
        }
    }

    class CACStarRemoteServerAcceptThread
    implements Runnable {
        CACStarRemoteServerAcceptThread() {
        }

        public void run() {
            logger.info("CACStar Remote Interface Server started.");
            try {
                while (CACStarRemoteServer.this.threadcond) {
                    Socket socket = CACStarRemoteServer.this.socket.accept();
                    remoteIP = socket.getInetAddress();
                    Thread thread = new Thread(new CACStarRemoteServerCommandThread(socket));
                    thread.start();
                    thread.join();
                    thread = null;
                    socket.close();
                    socket = null;
                }
            }
            catch (Exception exception) {
                logger.severe(exception.toString());
            }
            finally {
                Object var1_2 = null;
            }
        }
    }
}

