/*
 * Decompiled with CFR 0.152.
 */
package com.itekus.xcp.cacstar.protocol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class CACStarPacket {
    public static final int INVALID = -1;
    public static final int NULL = 0;
    public static final int RESET = 1;
    public static final int LOGOUT = 2;
    public static final int ACK = 100;
    public static final int NACK = 101;
    private int type;
    private Object obj;

    public Object getParameters() {
        return this.obj;
    }

    public int getType() {
        return this.type;
    }

    public CACStarPacket(int n, Object object) {
        this.type = n;
        this.obj = object;
    }

    public CACStarPacket() {
        this.type = -1;
        this.obj = null;
    }

    public void write(BufferedWriter bufferedWriter) throws IOException {
        switch (this.type) {
            default: {
                bufferedWriter.write("INVALID");
                break;
            }
            case 1: {
                bufferedWriter.write("RESET");
                break;
            }
            case 2: {
                bufferedWriter.write("LOGOUT");
                break;
            }
            case 100: {
                bufferedWriter.write("ACK");
                break;
            }
            case 101: {
                bufferedWriter.write("NACK");
            }
        }
        if (this.obj != null) {
            bufferedWriter.write("\n");
            bufferedWriter.write(this.obj.toString());
            bufferedWriter.write("\n");
        } else {
            bufferedWriter.write(";\n");
        }
        bufferedWriter.flush();
    }

    public int read(BufferedReader bufferedReader) throws IOException {
        boolean bl = false;
        String string = bufferedReader.readLine();
        boolean bl2 = false;
        if (string == null) {
            throw new IOException("EOF");
        }
        if ((string = string.replace("\r", "")).endsWith(";")) {
            string = string.replace(";", "");
        } else {
            bl2 = true;
        }
        if (!bl) {
            if ("RESET".equals(string)) {
                this.type = 1;
            }
            this.type = "LOGOUT".equals(string) ? 2 : ("ACK".equals(string) ? 100 : ("NACK".equals(string) ? 101 : -1));
        }
        return this.type;
    }
}

