/*
 * Decompiled with CFR 0.152.
 */
package com.itekus.xcp.cacstar.authplugin;

import com.itekus.xcp.cacstar.authplugin.CACStarRepository;
import com.itekus.xcp.cacstar.authplugin.CACStarRepositoryImpl;
import com.itekus.xcp.cacstar.authplugin.UserData;
import com.itekus.xcp.cacstar.protocol.AjaxConnector;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jp.co.fujixerox.xcp.security.auth.callback.CredentialCallback;
import jp.co.fujixerox.xcp.security.principal.AttributePrincipal;
import jp.co.fujixerox.xcp.security.principal.UniqueIDPrincipal;

public class CopyOfCACStarLoginModule
implements LoginModule {
    private Logger logger = Logger.getLogger(CopyOfCACStarLoginModule.class.getName());
    private CallbackHandler handler;
    private Map sharedState;
    private boolean debug = false;
    private static boolean loginDone = false;
    private static boolean commitDone = false;
    private static CACStarPrincipal loginPrincipal;
    private String userName;
    private String emailAddress;
    private String netFolder;
    private Subject subject;

    public CopyOfCACStarLoginModule() {
        System.out.println("CACStarLoginModule instantiated");
    }

    public static boolean isLoggedIn() {
        return commitDone;
    }

    public boolean abort() throws LoginException {
        System.out.println("CACStar Login Module ABORT called");
        if (!loginDone) {
            return false;
        }
        if (!commitDone) {
            loginPrincipal = null;
            loginDone = false;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        System.out.println("CACStar Login Module COMMIT called");
        if (loginDone && this.subject.getPrincipals(UniqueIDPrincipal.class).isEmpty()) {
            this.subject.getPrincipals().add((Principal)((Object)loginPrincipal));
            commitDone = true;
            return true;
        }
        return false;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        System.out.println("CACStar Login Module INITALIZE called");
        System.out.println("Subject=" + subject.toString() + " sharedState=" + map.toString());
        System.out.println("    " + map2.size() + "options=" + map2.toString());
        this.subject = subject;
        this.handler = callbackHandler;
        this.sharedState = map;
        this.userName = null;
        this.emailAddress = null;
        this.netFolder = null;
        if ("true".equals(map2.get("debug"))) {
            this.debug = true;
        }
    }

    public boolean login() throws LoginException {
        System.out.println("CACStar Login Module LOGIN() called");
        NameCallback nameCallback = new NameCallback("Prompt");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        CredentialCallback credentialCallback = new CredentialCallback("name");
        CredentialCallback credentialCallback2 = new CredentialCallback("mail");
        CredentialCallback credentialCallback3 = new CredentialCallback("netFolder");
        Callback[] callbackArray = new Callback[]{nameCallback, credentialCallback, credentialCallback2, credentialCallback3};
        try {
            this.handler.handle(callbackArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LoginException(iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            unsupportedCallbackException.printStackTrace();
            throw new LoginException(unsupportedCallbackException.getMessage());
        }
        this.userName = credentialCallback.getText();
        this.emailAddress = credentialCallback2.getText();
        this.netFolder = credentialCallback3.getText();
        CACStarRepository cACStarRepository = CACStarRepositoryImpl.getRepository();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", nameCallback.getName());
        hashMap.put("mail", this.emailAddress);
        hashMap.put("netFolder", this.netFolder);
        cACStarRepository.set("AuthUserInfo", hashMap);
        return this.login(nameCallback.getName(), null);
    }

    private boolean login(String string, char[] cArray) throws LoginException {
        System.out.println("CACStar Login Module LOGIN(" + string + ") called");
        UserData userData = new UserData();
        userData.setInfo("userName", this.userName);
        if (this.emailAddress.length() > 0) {
            userData.setInfo("emailAddress", this.emailAddress);
        }
        if (this.netFolder.length() > 0) {
            userData.setInfo("homeDirectory", this.netFolder);
        }
        loginPrincipal = new CACStarPrincipal(string, userData);
        loginDone = true;
        return true;
    }

    public boolean logout() throws LoginException {
        String string;
        loginDone = false;
        commitDone = false;
        loginPrincipal = null;
        boolean bl = true;
        CACStarRepository cACStarRepository = CACStarRepositoryImpl.getRepository();
        HashMap hashMap = new HashMap();
        cACStarRepository.set("AuthUserInfo", hashMap);
        try {
            string = AjaxConnector.request("http://172.19.10.1:8001/WebContent/scripts/doActionExt.php", "text/plain;charset=utf-8", null, "{\"method\":\"CACStarStatus\"}");
            if (string.contains("PromptMsg")) {
                bl = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            try {
                AjaxConnector.request("http://172.19.10.1:8001/WebContent/scripts/doActionExt.php", "text/plain;charset=utf-8", null, "{\"method\":\"CACStarLogout\"}");
                while ((string = AjaxConnector.request("http://172.19.10.1:8001/WebContent/scripts/doActionExt.php", "text/plain;charset=utf-8", null, "{\"method\":\"CACStarStatus\"}")) != null && string.contains("authenticated")) {
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    static class CACStarPrincipal
    implements UniqueIDPrincipal,
    AttributePrincipal {
        private String name;
        private Map attr;

        public CACStarPrincipal(String string) {
            System.out.println("CACStarPrincipal(" + string + ") called");
            this.name = string;
            this.attr = new HashMap();
        }

        public CACStarPrincipal(String string, UserData userData) {
            System.out.println("CACStarPrincipal(" + string + ", userData) called");
            System.out.println("    UserData=" + userData.getInfo("userName").toString());
            this.name = string;
            this.attr = new HashMap();
            this.attr.put("userName", userData.getInfo("userName"));
            if (userData.getInfo("emailAddress") != null) {
                this.attr.put("emailAddress", userData.getInfo("emailAddress"));
            }
            if (userData.getInfo("homeDirectory") != null) {
                this.attr.put("homeDirectory", userData.getInfo("homeDirectory"));
            }
            if (userData.getInfo("networkRealm") != null) {
                this.attr.put("networkRealm", userData.getInfo("networkRealm"));
            }
        }

        public String getName() {
            System.out.println("CACStarPrincipal returning name: " + this.name);
            return this.name;
        }

        public Map getAttribute() {
            System.out.println("CACStarPrincipal returning attributes.");
            return Collections.unmodifiableMap(this.attr);
        }
    }
}

