#!/bin/sh

copyright=""
progtitle="UX Filter Installer for Linux (x86)"
progname="$0"

PATH=/usr/ucb:/bin:/etc:/usr/bin:/usr/etc:/usr/sbin

# Setup default parameters
PrinterName=""
HOSTNAME=""
PACKAGE="dellpsfilter.tar"
TAPEDEV=""
REWIND=""

#### directorys ###
ROOT=
CURDIR="`pwd`"
BINDIR="${ROOT}/usr/local/dellbin3110"
MANDIR="${ROOT}/usr/share/man"

### utility for installation ###
BINS="txt2ps2 tiff2ps2 xwd2ps2 printcap.sample .dellpsdefault3110"
MAN1="txt2ps23110cn.1 tiff2ps23110cn.1 xwd2ps23110cn.1 dellpsif3110cn.1"

################################
## Printer Model Registration ##
################################
RegisterPrinterModels() {
Model dell3110cn dell3110cn.fd "Dell Color Laser Printer 3110cn"
} #EndRegisterPrinterModels

# model_pt<n> ... printer model name
# model_fd<n> ... FD file name(Not Use)
# model_mn<n> ... menu string
Model() {
	[ x"$ModelCount" = x ] && ModelCount=0
	eval ModelCount=`expr $ModelCount + 1`
	eval model_pt$ModelCount=$1
	eval model_fd$ModelCount=$2
	eval model_mn$ModelCount="\"$3\""
	eval fd_$1=$2
}

### Display Model Selet Menu
ModelSelectMenu() {
	echo "Please wait..."
	RegisterPrinterModels
	clear
	echo "$progtitle" ;echo "$copyright" ;echo ""
	echo "Printer Model?"
	i=1; tmp=$i; menustr=x
	while [ x"$menustr" != xExit ]; do
		eval menustr="\"\$model_mn$i\""
		[ $i -gt $ModelCount ] && menustr="Exit"
		echo "  ${i}. $menustr"
		[ $i -gt 1 ] && tmp="${tmp}/${i}"
		i=`expr $i + 1`
	done
	i=""
	while [ "`expr $i + 0 2>&1`" != "$i" ]; do
		echo -n "Enter Process No(${tmp})?:"
		read i
	done
	if [ $i -gt $ModelCount ]; then
		exit;
	fi
	eval PrinterName=\$model_pt$i
}

################################
# Local functions
#

### get OS Major Version ###
OSMVersion() {
	uname -r | awk '{printf ("%s",substr($1,1,1))}'
}

### get OS Version ###
OSVersion() {
	uname -r | awk '{printf ("%s",substr($1,1,3))}'
}

### nlecho message ###
nlecho() {
	echo ; echo $*
}

### errorexit exitcode message ###
errorexit() {
	nlecho "$progname:$2" 1>&2
	echo ; exit $1
}

### readparam message default_value
readparam() {
	if [ "$2" = "" ]; then
		echo ; echo -n "$1:"
		read parameter
	else
		echo ; echo -n "$1[$2]:"
		read parameter
		parameter="${parameter:-$2}"
	fi
}

### readenum message default_value
readenum() {
	parameter=""
	while [ "${parameter}" = "" ]; do
		echo ; echo -n "$1(1:$2 2:$3):"
		read parameter
		if [ "${parameter}" = "1" ]; then
			parameter="$2"
		elif [ "${parameter}" = "2" ]; then
			parameter="$3"
		else
			parameter=""
		fi
	done
}

### ask 'y' or 'n' ###
YesNo() {
	ans=""
	case "$2" in
		Yes|y)	dmsg="y" ;;
		No|n)	dmsg="n" ;;
		*)		dmsg=""  ;;
	esac
	while [ "$ans" = "" ]; do
		echo ; echo -n "$1(y/n)${dmsg:+[$dmsg]}:"
		read ans
		ans="${ans:-$dmsg}"
		if [ "$ans" = "y" -o "$ans" = "n" ]; then
			return
		fi
		echo "You must select 'y' or 'n'."
		ans=""
	done
}

### Menu ###
Menu() {
	n=$#; i=1; tmp=$i
	while [ $i -le $n ]; do
		echo "  ${i}. $1"
		if [ $i -gt 1 ]; then
			tmp="${tmp}/${i}"
		fi
		eval param_$i="\"$1\""
		shift; i=`expr $i + 1`
	done
	i=""
	while [ "`expr $i + 0 2>&1`" != "$i" ]; do
		echo -n "Enter Process No(${tmp})?:"
		read i
	done
	eval ans=\$param_"$i"
	return $i
}

### Extract ###
Extract() {
	install_directory=$1
	shift 1
	install_Zfiles=""
	install_files=""
	for f in $*; do
		install_Zfiles="${install_Zfiles} $f.Z"
		install_files="${install_files} $f"
	done
	${REWIND}
	cwd=`pwd`
	cd ${CURDIR}
	tar xvf ${PACKAGE} ${install_Zfiles}
	for f in ${install_files}; do
		gunzip ${f}
		install -g bin -o root $f ${install_directory}
		/bin/rm ${CURDIR}/$f
	done
	cd $cwd
}

### filename ###
filename() {
	set `echo $1 | sed 's/\// /g'`
	shift `expr $# - 1`
	echo $1
}

### found ###
found() {
	for i in $1; do
		if [ "${i}" = $2 ]; then
			return 0
		fi
	done
	return 1
}

### keyedit edit_file key addfile saved ###
keyedit() {
	echo -n "   $1 ... "
	RC=255
	grep "$2" $1 >/dev/null 2>&1
	case "$?" in
		0) echo "already edited." ;;
		2) echo "file not found." ;;
		1) if [ ! -f "$4/`filename $1`" ]; then
				cp $1 $4
				RC=0
			fi
			if [ -w $1 ]; then
				cat $3 >> $1 2>/dev/null
				echo "done"
			else
				echo "Permission denied."
			fi
			;;
	esac
	return ${RC}
}
### read parameter with confirm ###
ReadParamWithConfirm() {
	parameter=""
	while [ "${parameter}" = "" ]; do
		readparam "Enter $1?" "$2"
		if [ "$#" = "2" ]; then
			YesNo "$1 is '${parameter}'" "y"
			if [ "$ans" = "n" ]; then
				parameter=""
			fi
		elif [ $3 ${parameter} ]; then
			parameter=""
		fi
	done
}

### read printer name with confirm ###
ReadPrinterNameWithConfirm() {
	parameter=""
	while [ "${parameter}" = "" ]; do
		readparam "Enter $1?" "$2"
		if (echo ${parameter} | grep "[^a-zA-Z0-9_]"); then
			echo "$1 can contains alphanumeric characters and underscores"
			parameter=""
		else
			if [ "`echo -n ${parameter} | wc -c`" -le 14 ]; then
				YesNo "$1 is '${parameter}'" "y"
				if [ "$ans" = "n" ]; then
					parameter=""
				fi
			else
				echo "$1 exceeds 14 character"
				parameter=""
			fi
		fi
	done
}

### Make binary install directry
mk_BINDIR() {
	LINKBDIR=""
	WORKPARAM=""
	OK="n"
	while [ "${LINKBDIR}" = "" ]; do
		while [ "${OK}" = "n" ]; do
			readparam "Enter binary directory name" "${BINDIR}"
			if [ `expr substr ${parameter} 1 1` != "/" ]; then
				YesNo "directory is '`pwd`/${parameter}'  " n
				WORKPARAM="`pwd`/${parameter}"
			else
				YesNo "directory is '${parameter}'  " n
				WORKPARAM="${parameter}"
			fi
			OK=${ans}
		done
		LINKBDIR="${WORKPARAM}"
		if [ -d ${LINKBDIR} ]; then
			echo "'${LINKBDIR}' is already exist."
			YesNo "Erase ${BINS} in '${LINKBDIR}'. Confirm?" n
			if [ "$ans" = "y" ]; then
				dir=`pwd`
				echo -n "'delete..."
				cd ${LINKBDIR}
				rm -rf ${BINS}
				cd ${dir}
				echo "done"
			fi
		fi
	done
	if [ "${LINKBDIR}" != "${BINDIR}" ]; then
		mkdir ${LINKBDIR}
		BINDIR="${LINKBDIR}"
	else
		[ ! -d $BINDIR ] && mkdir $BINDIR
	fi
	set `df ${BINDIR}` ; shift 7
	FREE="$4" ; FILESYS="$6"
	if [ ${FREE:=0} -lt 5120 ]; then
		nlecho "Not enough space in '${FILESYS}' file system."
		rm -rf ${LINKBDIR}
		errorexit 255 "Installation give up."
	fi
}

### do symbolic link ###
LN_S() {
	[ -f $2 ] && rm -f $2	# remove, if $2 already exists.
	ln -s $1 $2
}

### do hard link ###
LN_H() {
	[ -f $2 ] && rm -f $2	# remove, if $2 already exists.
	ln $1 $2
}

### Linux Install ###
Linux_Install() {
	YesNo "Install Filters?" "y"
	if [ "$ans" = "y" ]; then
		mk_BINDIR
		install -d -m 755 ${BINDIR}
		Extract ${BINDIR} ${BINS}
		if [ -d ${MANDIR} ]; then
			Extract ${MANDIR}/man1 ${MAN1}
		fi
		LN_H ${BINDIR}/txt2ps2 ${BINDIR}/dellpsif
	fi
}

################################
# START Installation Here
################################
if [ "`whoami`" != "root" ]; then
	errorexit 255 "should be used by 'root'."
fi
ModelSelectMenu
Linux_Install
echo ""
echo "done."
##### END-OF-INSTALL #####
