#!/bin/sh

copyright=""
progtitle="UX Filter Installer for HP-UX (PA-RISC)"
progname="$0"

PATH=/usr/ucb:/bin:/etc:/usr/bin:/usr/etc:/usr/sbin:/usr/lib

# Setup default parameters
PrinterName=""
HOSTNAME=""
PACKAGE="dellpsfilter.tar"
REWIND=""

#### directorys ###
ROOT=
CURDIR="`pwd`"
BINDIR="/usr/local/dellbin3110"
MANDIR="/usr/share/man"
CHANGE_EXEC="change"

### utility for installation ###
BINS="txt2ps2 xwd2ps2 tiff2ps2"
MAN1="txt2ps23110cn.1 tiff2ps23110cn.1 xwd2ps23110cn.1"
IFFILE="interface3110cn"
INTERZ="change.Z interface3110cn.Z"

################################
## Printer Model Registration ##
################################
RegisterPrinterModels() {
Model dell3110cn interface3110cn "Dell Color Laser Printer 3110cn"
}
# model_pt<n> ... printer model name
# model_fd<n> ... HP-UX interface file name
# model_mn<n> ... menu string
Model() {
	[ x"$ModelCount" = x ] && ModelCount=0
	eval ModelCount=`expr $ModelCount + 1`
	eval model_pt$ModelCount=$1
	eval model_fd$ModelCount=$2
	eval model_mn$ModelCount="\"$3\""
	eval fd_$1=$2
}

### Display Model Selet Menu
ModelSelectMenu() {
	echo "Please wait..."
	RegisterPrinterModels
	clear
	echo "$progtitle" ;echo "$copyright" ;echo ""
	echo "Printer Model?"
	i=1; tmp=$i; menustr=x
	while [ x"$menustr" != xExit ]; do
		eval menustr="\"\$model_mn$i\""
		[ $i -gt $ModelCount ] && menustr="Exit"
		echo "  ${i}. $menustr"
		[ $i -gt 1 ] && tmp="${tmp}/${i}"
		i=`expr $i + 1`
	done
	i=""
	while [ "`expr $i + 0 2>&1`" != "$i" ]; do
		echo "Enter Process No(${tmp})?:\c"
		read i
	done
	if [ $i -gt $ModelCount ]; then
		exit;
	fi
	eval INTERFACE=\$model_fd$i
	eval PrinterName=\$model_pt$i
}

################################
# Local functions
#

### nlecho message ###
nlecho() {
	echo ; echo $*
}

### errorexit exitcode message ###
errorexit() {
	nlecho "$progname:$2" 1>&2
	echo ; exit $1
}

### readparam message default_value
readparam() {
	if [ "$2" = "" ]; then
		echo ; echo "$1:\c"
		read parameter
	else
		echo ; echo "$1[$2]:\c"
		read parameter
		parameter="${parameter:-$2}"
	fi
}

### ask 'y' or 'n' ###
YesNo() {
	ans=""
	case "$2" in
		Yes|y)	dmsg="y" ;;
		No|n)	dmsg="n" ;;
		*)		dmsg=""  ;;
	esac
	while [ "$ans" = "" ]; do
		echo ; echo "$1(y/n)${dmsg:+[$dmsg]}:\c"
		read ans
		ans="${ans:-$dmsg}"
		if [ "$ans" = "y" -o "$ans" = "n" ]; then
			return
		fi
		echo "You must select 'y' or 'n'."
		ans=""
	done
}

### read printer name with confirm ###
ReadPrinterNameWithConfirm() {
	parameter=""
	msg=$1
	while [ "${parameter}" = "" ]; do
		readparam "Enter $msg?" ""
		if (echo ${parameter} | grep "[^a-zA-Z0-9_]"); then
			echo "$msg can contains alphanumeric characters and underscores"
			parameter=""
		else
			if [ "`echo ${parameter} | wc -c\c`" -le 14 ]; then
				YesNo "$msg is '${parameter}'" "y"
				if [ "$ans" = "n" ]; then
					parameter=""
				fi
			else
				echo "$msg exceeds 14 character"
				parameter=""
			fi
		fi
	done
}

### Menu ###
Menu() {
	n=$#; i=1; tmp=$i
	while [ $i -le $n ]; do
		echo " ${i}. $1"
		if [ $i -gt 1 ]; then
			tmp="${tmp}/${i}"
		fi
		eval param_$i="\"$1\""
		shift; i=`expr $i + 1`
	done
	i=""
	while [ "`expr $i + 0 2>&1`" != "$i" ]; do
		echo -n "Enter Process No(${tmp})?:"
		read i
	done
	eval ans=\$param_"$i"
	return $i
}

#Make binary install directry
mk_BINDIR() {
	LINKBDIR=""
	WORKPARAM=""
	OK="n"
	while [ "${LINKBDIR}" = "" ]; do
		while [ "${OK}" = "n" ]; do
			readparam "Enter install directory name" "${BINDIR}"
			if [ `expr substr ${parameter} 1 1` != "/" ]; then
				YesNo "directory is '`pwd`/${parameter}'  " n
				WORKPARAM="`pwd`/${parameter}"
			else
				YesNo "directory is '${parameter}'  " n
				WORKPARAM="${parameter}"
			fi
			OK=${ans}
		done
		LINKBDIR="${WORKPARAM}"
		if [ -d ${LINKBDIR} ]; then
			echo "'${LINKBDIR}' is already exist."
			YesNo "Erase ${BINS} in '${LINKBDIR}'. Confirm?" n
			if [ "$ans" = "y" ]; then
				dir=`pwd`
				echo "'delete..."
				cd ${LINKBDIR}
				rm -rf ${BINS}
				cd ${dir}
				echo "done"
			fi
		fi
	done
	if [ "${LINKBDIR}" != "${BINDIR}" ]; then
		mkdir -p ${LINKBDIR}
		BINDIR="${LINKBDIR}"
	else
		[ ! -d $BINDIR ] && mkdir -p $BINDIR
	fi
}

### Extract ###
Extract() {
	for f in ${BINS}; do
		uncompress $f.Z
		cpset $f $BINDIR 0755 lp lp
	done
	if [ -d $MANDIR ]; then
		if [ ! -d $MANDIR/man1 ]; then
			mkdir $MANDIR/man1
		fi
		for f in ${MAN1}; do
			uncompress $f.Z
			cpset $f $MANDIR/man1 0444 bin bin
		done
	fi
	for f in ${BINS}; do
		rm -f $CURDIR/$f
	done
	for f in ${MAN1}; do
		rm -f $CURDIR/$f
	done
	for f in ${IFFILE}; do
		rm -f $CURDIR/$f
	done
	rm -f version
}

### Make Logical Interface File (for HP-UX) ###
# $* ... template filename list
make_logical_interface_hpux() {
	## set output printer name
	TMPDIR=`$CURDIR/$CHANGE_EXEC $BINDIR`
	sed -e "s/PRINTER=/PRINTER="$OUTPUT_PNAME"/" \
		-e "s/HOME=/HOME="$TMPDIR"/" \
		< $CURDIR/$INTERFACE > $CURDIR/$INTERFACE.$LOGICAL_PNAME
	interface_hpux=`echo "$CURDIR/$INTERFACE.$LOGICAL_PNAME"`
}

### Register logical printer (for HP-UX) ###
register_logical_printer() {
	make_logical_interface_hpux
	lpadmin -p$LOGICAL_PNAME -v/dev/null -i$interface_hpux
	accept $LOGICAL_PNAME 2>&1 > /dev/null
	enable $LOGICAL_PNAME 2>&1 > /dev/null
	rm -f $interface_hpux
	rm -f $CURDIR/$CHANGE_EXEC
}

###
mylpsched() {
	TMP=$LANG
	LANG=C
	export LANG
	if [ ! "`lpstat -r`" = "scheduler is running" ]; then
		if [ ! -f /usr/lib/lpsched ]; then
			echo "install.sh:should install LP-SPOOL filesets"
			exit
		fi
		/usr/lib/lpsched 2>&1 > /dev/null
	fi
	LANG=$TMP
	export LANG
}

###
mylpshut() {
	TMP=$LANG
	LANG=C
	export LANG
	if [ "`lpstat -r`" = "scheduler is running" ]; then
		if [ ! -f /usr/lib/lpshut ]; then
			echo "install.sh:should install LP-SPOOL filesets"
			exit
		fi
		/usr/lib/lpshut 2>&1 > /dev/null
	fi
	LANG=$TMP
	export LANG
}

### HP-UX Install ###
HPUX_Install() {
	###
	tar xvf $PACKAGE
	for f in ${INTERZ}; do
		uncompress $f
	done
	mk_BINDIR
	clear
	###
	mylpsched
	echo; echo "HP-UX Installation for $PrinterName Type Printer"
	### Input output-printer name
	ReadPrinterNameWithConfirm "output-printer-name" ""
	OUTPUT_PNAME=${parameter}
	TMP=`lpstat -a | awk '{print substr($1, 0, length($1))}' | grep $OUTPUT_PNAME`
	for i in $TMP; do
		if [ "$i" = "$OUTPUT_PNAME" ]; then
			break
		fi
	done
	while [ "$i" != "$OUTPUT_PNAME" ]; do
		clear
		echo "The printer '$OUTPUT_PNAME' is not installed"
		ReadPrinterNameWithConfirm "output-printer-name" ""
		OUTPUT_PNAME=${parameter}
		TMP=`lpstat -a | awk '{print substr($1, 0, length($1))}' | grep $OUTPUT_PNAME`
		for i in $TMP; do
			if [ "$i" = "$OUTPUT_PNAME" ]; then
				break
			fi
		done
	done
	### Input logical-printer name
	ReadPrinterNameWithConfirm "logical-printer-name" ""
	LOGICAL_PNAME=${parameter}
	TMP=`lpstat -a | awk '{print substr($1, 0, length($1))}' | grep $LOGICAL_PNAME`
	for i in $TMP; do
		if [ "$i" = "$LOGICAL_PNAME" ]; then
			break
		fi
	done
	while [ "$i" = "$LOGICAL_PNAME" ]; do
		clear
		echo "The printer '$LOGICAL_PNAME' has already been installed"
		ReadPrinterNameWithConfirm "logical-printer-name" ""
		LOGICAL_PNAME=${parameter}
		TMP=`lpstat -a | awk '{print substr($1, 0, length($1))}' | grep $LOGICAL_PNAME`
		for i in $TMP; do
			if [ "$i" = "$LOGICAL_PNAME" ]; then
				break
			fi
		done
	done
	### Install logical-printer
	mylpshut
	register_logical_printer
	mylpsched
	###
	Extract
	echo "${BINDIR}" > /tmp/dellbinpath3110
	mkdir -p /usr/lib/lp/postscript
	cpset /tmp/dellbinpath3110 /usr/lib/lp/postscript 0755 root sys
	rm -f /tmp/dellbinpath3110
}

################################
# START Installation Here
################################
if [ "`whoami`" != "root" ]; then
	errorexit 255 "should be used by 'root'."
fi
case "`uname -s`" in
	HP-UX)
		ModelSelectMenu
		HPUX_Install ;;
	*)
		echo; echo "Unsupported OS type."; exit 255 ;;
esac
echo ""
echo "done."

##### END-OF-INSTALL #####
