#!/bin/sh

copyright=""
progtitle="UX Filter Installer for Solaris (SPARC)"
progname="$0"

PATH=/usr/ucb:/bin:/etc:/usr/bin:/usr/etc:/usr/sbin

# Setup default parameters
PrinterName=""
HOSTNAME=""
PACKAGE="dellpsfilter.tar"
REWIND=""

#### directorys ###
ROOT=
CURDIR="`pwd`"
BINDIR="${ROOT}/usr/local/dellbin3110"
MANDIR="${ROOT}/usr/share/man"
TERMINFO="${ROOT}/usr/share/lib/terminfo"
MODEL_PATH="${ROOT}/usr/lib/lp/model"

### utility for installation ###
BINS="txt2ps2 sunras2ps2 tiff2ps2 xwd2ps2"
MAN1="txt2ps23110cn.1 sunras2ps23110cn.1 tiff2ps23110cn.1 xwd2ps23110cn.1 dellpsif3110cn.1"
UXFDS="posttxt3110cn.fd download3110.fd postio3110cn.fd"
OSFILTERS="download dpost postdaisy postdmd postio postior postmd postplot postprint postreverse posttek "

################################
## Printer Model Registration ##
################################
RegisterPrinterModels() {
Model dell3110cn dell3110cn.fd "Dell Color Laser Printer 3110cn"
}

# model_pt<n> ... printer model name
# model_fd<n> ... Solaris FD file name
# model_mn<n> ... menu string
Model() {
	[ x"$ModelCount" = x ] && ModelCount=0
	eval ModelCount=`expr $ModelCount + 1`
	eval model_pt$ModelCount=$1
	eval model_fd$ModelCount=$2
	eval model_mn$ModelCount="\"$3\""
	eval fd_$1=$2
}

## Display Model Selet Menu
ModelSelectMenu() {
	echo "Please wait..."
	RegisterPrinterModels
	clear
	echo "$progtitle"; echo "$copyright"; echo ""
	echo "Printer Model?"
	i=1; tmp=$i; menustr=x
	while [ x"$menustr" != xExit ]; do
		eval menustr="\"\$model_mn$i\""
		[ $i -gt $ModelCount ] && menustr="Exit"
		echo "  ${i}. $menustr"
		[ $i -gt 1 ] && tmp="${tmp}/${i}"
		i=`expr $i + 1`
	done
	i=""
	while [ "`expr $i + 0 2>&1`" != "$i" ]; do
		echo -n "Enter Process No(${tmp})?:"
		read i
	done
	if [ $i -gt $ModelCount ]; then
		exit;
	fi
	eval PrinterName=\$model_pt$i
}


################################
# Local functions
#

### get OS Major Version ###
OSMVersion() {
	uname -r | awk '{printf ("%s",substr($1,1,1))}'
}

### get OS Version ###
OSVersion() {
	uname -r | awk '{printf ("%s",substr($1,1,3))}'
}

### nlecho message ###
nlecho() {
	echo ; echo $*
}

### errorexit exitcode message ###
errorexit() {
	nlecho "$progname:$2" 1>&2
	echo ; exit $1
}

### readparam message default_value
readparam() {
	if [ "$2" = "" ]; then
		echo ; echo -n "$1:"
		read parameter
	else
		echo ; echo -n "$1[$2]:"
		read parameter
		parameter="${parameter:-$2}"
	fi
}

### readenum message default_value
readenum() {
	parameter=""
	while [ "${parameter}" = "" ]; do
		echo ; echo -n "$1(1:$2 2:$3):"
		read parameter
		if [ "${parameter}" = "1" ]; then
			parameter="$2"
		elif [ "${parameter}" = "2" ]; then
			parameter="$3"
		else
			parameter=""
		fi
	done
}

### ask 'y' or 'n' ###
YesNo() {
	ans=""
	case "$2" in
		Yes|y)	dmsg="y";;
		No|n)	dmsg="n";;
		*)		dmsg="";;
	esac
	while [ "$ans" = "" ]; do
		echo; echo -n "$1(y/n)${dmsg:+[$dmsg]}:"
		read ans
		ans="${ans:-$dmsg}"
		if [ "$ans" = "y" -o "$ans" = "n" ]; then
			return
		fi
		echo "You must select 'y' or 'n'."
		ans=""
	done
}

### Menu ###
Menu() {
	n=$#; i=1; tmp=$i
	while [ $i -le $n ]; do
		echo "  ${i}. $1"
		if [ $i -gt 1 ]; then
			tmp="${tmp}/${i}"
		fi
		eval param_$i="\"$1\""
		shift; i=`expr $i + 1`
	done
	i=""
	while [ "`expr $i + 0 2>&1`" != "$i" ]; do
		echo -n "Enter Process No(${tmp})?:"
		read i
	done
	eval ans=\$param_"$i"
	return $i
}

### Extract ###
Extract() {
	install_directory=$1
	shift 1
	install_Zfiles=""
	install_files=""
	for f in $*; do
		install_Zfiles="${install_Zfiles} ${f}.Z"
		install_files="${install_files} $f"
	done
	${REWIND}
	cwd=`pwd`
	cd ${CURDIR}
	tar xvf ${PACKAGE} ${install_Zfiles}
	for f in ${install_files}; do
		uncompress ${f}
		install -g lp -o lp $f ${install_directory}
		/bin/rm ${CURDIR}/$f
	done
	cd $cwd
}

### filename ###
filename() {
	set `echo $1 | sed 's/\// /g'`
	shift `expr $# - 1`
	echo $1
}

### found ###
found() {
	for i in $1; do
		if [ "${i}" = $2 ]; then
			return 0
		fi
	done
	return 1
}

### keyedit edit_file key addfile saved ###
keyedit() {
	echo -n "   $1 ... "
	RC=255
	grep "$2" $1 >/dev/null 2>&1
	case "$?" in
		0) echo "already edited.";;
		2) echo "file not found.";;
		1) if [ ! -f "$4/`filename $1`" ]; then
				cp $1 $4
				RC=0
			fi
			if [ -w $1 ]; then
				cat $3 >> $1 2>/dev/null
				echo "done"
			else
				echo "Permission denied."
			fi
			;;
	esac
	return ${RC}
}

### read parameter with confirm ###
ReadParamWithConfirm() {
	parameter=""
	while [ "${parameter}" = "" ]; do
		readparam "Enter $1?" "$2"
		if [ "$#" = "2" ]; then
			YesNo "$1 is '${parameter}'" "y"
			if [ "$ans" = "n" ]; then
				parameter=""
			fi
		elif [ $3 ${parameter} ]; then
			parameter=""
		fi
	done
}

### read printer name with confirm ###
ReadPrinterNameWithConfirm() {
	parameter=""
	while [ "${parameter}" = "" ]; do
		readparam "Enter $1?" "$2"
		if (echo ${parameter} | grep "[^a-zA-Z0-9_]"); then
			echo "$1 can contains alphanumeric characters and underscores"
			parameter=""
		else
			if [ "`echo -n ${parameter} | wc -c`" -le 14 ]; then
				YesNo "$1 is '${parameter}'" "y"
				if [ "$ans" = "n" ]; then
					parameter=""
				fi
			else
				echo "$1 exceeds 14 character"
				parameter=""
			fi
		fi
	done
}

### Make binary install directry
mk_BINDIR() {
	LINKBDIR=""
	WORKPARAM=""
	OK="n"
	while [ "${LINKBDIR}" = "" ]; do
		while [ "${OK}" = "n" ]; do
			readparam "Enter binary directory name" "${BINDIR}"
			if [ `expr substr ${parameter} 1 1` != "/" ]; then
				YesNo "directory is '`pwd`/${parameter}'  " n
				WORKPARAM="`pwd`/${parameter}"
			else
				YesNo "directory is '${parameter}'  " n
				WORKPARAM="${parameter}"
			fi
			OK=${ans}
		done
		LINKBDIR="${WORKPARAM}"
		if [ -d ${LINKBDIR} ]; then
			echo "'${LINKBDIR}' is already exist."
			YesNo "Erase ${bins_solaris} in '${LINKBDIR}'. Confirm?" n
			if [ "$ans" = "y" ]; then
				dir=`pwd`
				echo -n "'delete..."
				cd ${LINKBDIR}; rm -rf ${BINS}
				cd ${dir}
				echo "done"
			fi
		fi
	done
	if [ "${LINKBDIR}" != "${BINDIR}" ]; then
		BINDIR="${LINKBDIR}"
	else
		[ ! -d $BINDIR ] && mkdir $BINDIR
	fi
}

### do symbolic link ###
LN_S() {
	[ -f $2 ] && rm -f $2	# remove, if $2 already exists.
	ln -s $1 $2
}

### do hard link ###
LN_H() {
	[ -f $2 ] && rm -f $2	# remove, if $2 already exists.
	ln $1 $2
}

### Register filters by lpfilter command (For Solaris) ###
register_filters() {
	dir=`pwd`
	cd /etc/lp/fd
	regsitered=`lpfilter -f all -l | awk -F\" '/^\(Filter /{print $2}'`
	reinstall=""
	for f in ${regsitered}; do
		if [ -f ${f}.fd ]; then
			if (found "${OSFILTERS}" ${f}); then
				YesNo "Do you want remove '${f}'filter and re-install" "y"
				if [ "$ans" = "y" ]; then
					reinstall="${reinstall} ${f} "
				fi
			fi
		fi
	done
	for f in ${solaris_filters}; do
		lpfilter -f ${f} -F ${f}.fd
	done
	for f in ${OSFILTERS}; do
		if [ -f ${f}.fd ]; then
			if (found "${reinstall}" ${f}); then
				lpfilter -f ${f} -x
				lpfilter -f ${f} -F ${f}.fd
			elif (found "${regsitered}" ${f}); then
				echo -n ""
			else
				YesNo "Do you want install '${f}'filter" "y"
				if [ "$ans" = "y" ]; then
					lpfilter -f ${f} -F ${f}.fd
				fi
			fi
		fi
	done
	cd ${dir}
}

### Add Port Service (For Solaris) ###
addport_service() {
	YesNo "Do you want set port-monitor?" "y"
	if [ "$ans" = "y" ]; then
		UA=`lpsystem -A`
		UA0=`lpsystem -A | awk '{printf("%s0ACE%s",substr($1,1,4),substr($1,9))}'`
		sacadm -a -p tcp -t listen -c "/usr/lib/saf/listen tcp" \
			-v `nlsadmin -V` -n 9999 2> /dev/null
		pmadm -a -p tcp -s lp -i root \
			-m `nlsadmin -o /var/spool/lp/fifos/listenS5` \
			-v `nlsadmin -V` 2> /dev/null
		pmadm -a -p tcp -s lpd -i root \
			-m `nlsadmin -o /var/spool/lp/fifos/listenBSD -A "\x${UA}"`\
			-v `nlsadmin -V` 2> /dev/null
		pmadm -a -p tcp -s 0 -i root \
			-m `nlsadmin -c /usr/lib/saf/nlps_server -A "\x${UA0}"`\
			-v `nlsadmin -V` 2> /dev/null
	fi
}

### Extract solaris binary from tape ###
install_solaris_binary() {
	eval fd=\$fd_"$PrinterName"
	UXFDS="$UXFDS $fd"
	solaris_filters=""
	for i in $UXFDS; do
		solaris_filters="$solaris_filters `basename $i .fd`"
	done
	install -d -m 755 ${BINDIR}
	Extract ${BINDIR} ${BINS}
	Extract /etc/lp/fd ${UXFDS}
	if [ -d ${MANDIR} ]; then
		Extract ${MANDIR}/man1 ${MAN1}
	fi
	# do binary hard link
	MTYPE="3110cn"
	LN_H ${BINDIR}/txt2ps2 ${BINDIR}/dellpsif
	# do symbolic link
	LN_S ${BINDIR}/txt2ps2 /usr/lib/lp/postscript/dellposttxt${MTYPE}
	LN_S ${BINDIR}/dellpsif /usr/lib/lp/postscript/dellpostps${MTYPE}
	/usr/bin/chown -h lp /usr/lib/lp/postscript/dellposttxt${MTYPE} /usr/lib/lp/postscript/dellpostps${MTYPE}
	/usr/bin/chgrp -h lp /usr/lib/lp/postscript/dellposttxt${MTYPE} /usr/lib/lp/postscript/dellpostps${MTYPE}
	echo "${BINDIR}" > /tmp/dellbinpath3110
	install -g bin -o root /tmp/dellbinpath3110 /usr/lib/lp/postscript
	rm -f /tmp/dellbinpath3110
	## make terminfo link ###
	firstchar=`echo ${PrinterName} | awk '{printf("%s",substr($1,1,1))}`
	if [ ! -d ${TERMINFO}/${firstchar} ]; then
		mkdir ${TERMINFO}/${firstchar}
	fi
	LN_S ${TERMINFO}/P/PS ${TERMINFO}/${firstchar}/${PrinterName}
}

### Solaris 2.6 check ###
Solaris26() {
	if [ "`uname -s`" = "SunOS" -a `uname -r | cut -d. -f2` -ge 6 ]; then
		echo "true" 	# Solaris 2.6 or later
	else
		echo "false"	# Solaris 2.5 or older
	fi
}

### Solaris 2.4 check ###
Solaris24() {
	if [ "`uname -s`" = "SunOS" -a `uname -r | cut -d. -f2` -ge 5 ]; then
		echo "true" 	# Solaris 2.5 or later
	else
		echo "false"	# Solaris 2.4 or older
	fi
}

### Make Interface File (for Solaris) ###
# $* ... template filename list
make_interface_solaris() {
	interface_solaris=""
	for i in $*; do
		if [ -f $MODEL_PATH/$i ]; then
			interface_solaris=$PrinterName
			sed -e "s/\([^A-Za-z]*\)PS\([^A-Za-z]\)/\1$PrinterName\2/g" \
				-e "s/\([^A-Za-z]*\)PS\(R[^A-Za-z]\)/\1$PrinterName\2/g" \
				-e 's/\(\`*.\)\(date .*\`\)/\1env LANG=C \2/g' \
				$MODEL_PATH/$i >$interface_solaris
			install -c -o lp -g lp $interface_solaris $MODEL_PATH
			rm -f $interface_solaris
			break
		fi
	done
	if [ $interface_solaris = "" ]; then
		if [ "`Solaris26`" = "true" ]; then
			errorexit 255 "should install SUNWpsu Package."
		else
			errorexit 255 "should install SUNWlps Package."
		fi
	fi
}

### Register local printer (for Solaris) ###
register_local_printer() {
	mk_BINDIR
	install_solaris_binary
	register_filters
	make_interface_solaris standard
	lpadmin -p $NAME -T $PrinterName -I PS -D "$COMMENT" \
		-v $PORT -i $MODEL_PATH/$interface_solaris
	accept $NAME
	enable $NAME
}

### Register network printer with local filtering (for Solaris) ###
register_network_printer() {
### MODEL_PATH=/usr/lib/lp/model
	mk_BINDIR
	install_solaris_binary
	register_filters
	if [ "`Solaris26`" = "true" ]; then
		make_interface_solaris netstandard
		lpadmin -p $NAME -T $PrinterName -I PS \
			-D "$COMMENT" -o dest=${PSERVER}:${RPRINTER} -o protocol=bsd \
			-v /dev/null -i $MODEL_PATH/$interface_solaris
	else
		lpsystem -t bsd $PSERVER
		lpadmin -p $NAME -T $PrinterName -I PS \
			-D "$COMMENT" -s ${PSERVER}\!${RPRINTER}
	fi
	accept $NAME
	enable $NAME
}

### Register remote system access (for Solaris) ###
register_remote_system() {
	mk_BINDIR
	if [ "`Solaris26`" = "true" ]; then
		lpadmin -p $NAME -s ${PSERVER}\!${RPRINTER}
		lpset -a description="$COMMENT" $NAME
	else
		readenum  "Enter '$PSERVER' system?" "s5" "bsd"
		SYSTEM=${parameter}
		lpsystem -t $SYSTEM $PSERVER
		YesNo "Use Filter in Print Server" "y"
		if [ "$ans" = "y" ]; then
			lpadmin -p $NAME -T PS -I any \
				-s ${PSERVER}\!${RPRINTER} -D "$COMMENT"
		else
			install_solaris_binary
			register_filters
			lpadmin -p $NAME -T $PrinterName -I PS \
				-s ${PSERVER}\!${RPRINTER} -D "$COMMENT"
		fi
		accept $NAME
		enable $NAME
	fi
}

### Solaris Install ###
Solaris_Install() {
	COMMENT="Dell $PrinterName Type Printer"
	if [ ! "`lpstat -r`" = "scheduler is running" ]; then
		/usr/lib/lpsched
		if [ ! "`lpstat -r`" = "scheduler is running" ]; then
			if [ "`Solaris26`" = "true" ]; then
				errorexit 255 "should install SUNWpsu Package."
			else
				errorexit 255 "should install SUNWlpu Package."
			fi
		fi
	fi
	echo; echo "Solaris Installation for $PrinterName Type Printer"
	Menu "Set Local Printer" "Set Remote Printer"
	if [ "${ans}" = "Set Local Printer" ]; then
		### serial
		#PORT=/dev/term/a
		#PORT=/dev/term/b
		### parallel
		#PORT=/dev/bpp0
		PORT=/dev/ecpp0
		ReadParamWithConfirm "port-device-name" "$PORT" "! -c "
		PORT=${parameter}
		chown lp ${PORT}
		chmod 600 ${PORT}
		ReadPrinterNameWithConfirm "printer-name" "${PrinterName}"
		NAME=${parameter}
		register_local_printer
		[ "`Solaris26`" = "false" ] && addport_service
	elif [ "${ans}" = "Set Printer Server" ]; then
		OK="n"
		while [ "${OK}" = "n" ]; do
			readparam "Enter client-hostnames" ""
			OK="y"
			for i in ${parameter}; do
				YesNo "Client is '${i}' " "Yes"
				if [ "${ans}" = "n" ]; then
					OK="n"
					break
				fi
			done
		done
		HOSTS=${parameter}
		for HOST in ${HOSTS}; do
			readenum "Enter '${HOST}'system?" "s5" "bsd"
			lpsystem -t ${parameter} ${HOST}
		done
		addport_service
	elif [ "${ans}" = "Set Remote Printer" ]; then
		ReadParamWithConfirm "server-hostname" ""
		PSERVER=${parameter}
		ReadPrinterNameWithConfirm "server-printer-name" ""
		RPRINTER=${parameter}
		ReadPrinterNameWithConfirm "client-printer-name" ""
		NAME=${parameter}
		YesNo "'$PSERVER' is network printer" "y"
		if [ "$ans" = "y" ]; then
			register_network_printer
		else
			register_remote_system
		fi
	fi
}

################################
# START Installation Here
################################
#/usr/ucb/clear
if [ "`whoami`" != "root" ]; then
	errorexit 255 "should be used by 'root'."
fi
case "`uname -s`" in
	SunOS)
		case "`uname -r`" in
			5.6* | 5.7* | 5.8 | 5.9*)
				ModelSelectMenu
				Solaris_Install ;;
			5.10*)
				ModelSelectMenu
				Solaris_Install
				svcadm enable svc:/application/print/server ;;
			*)
				echo; echo "Unsupported OS type."; exit 255 ;;
		esac ;;
	*)
		echo; echo "Unsupported OS type."; exit 255 ;;
esac
cp /etc/lp/interfaces/${NAME} /tmp/${NAME}
sed 's/nobanner=no/nobanner=yes/g' /tmp/${NAME} > /etc/lp/interfaces/${NAME}
rm /tmp/${NAME}
echo ""
echo "done."

##### END-OF-INSTALL #####
