/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.IppUtil;

import com.xerox.IppData.Attribute;
import com.xerox.IppData.AttributeGroup;
import com.xerox.IppData.AttributeValue;
import com.xerox.IppData.CollectionValue;
import com.xerox.IppData.ValueElementFactory;
import com.xerox.IppOps.ChainedException;
import com.xerox.IppOps.EventLog;
import com.xerox.IppOps.EventRecord;
import com.xerox.IppOps.IppObject;
import com.xerox.IppOps.IppObjectConfig;
import com.xerox.IppOps.IppObjectPlus;
import com.xerox.IppOps.OperationRequest;
import com.xerox.IppOps.OperationResponse;
import com.xerox.IppOps.iAttrGroupSet;
import com.xerox.IppOps.iAttribute;
import com.xerox.IppOps.iAttributeGroup;
import com.xerox.IppOps.iAttributeValue;
import com.xerox.IppOps.iCertificateAccept;
import com.xerox.IppOps.iDateTimeValue;
import com.xerox.IppOps.iEventLog;
import com.xerox.IppOps.iIntegerValue;
import com.xerox.IppOps.iOperationResponse;
import com.xerox.IppOps.iProgressObserverSupport;
import com.xerox.IppOps.iStringValue;
import com.xerox.IppOps.iValueElement;
import com.xerox.IppOps.iValueElementFactory;
import com.xerox.IppOps.iWithoutLangValue;
import com.xerox.IppUtil.CertificateAccept;
import com.xerox.IppUtil.DataOutputWriter;
import com.xerox.IppUtil.IntervalTimer;
import com.xerox.IppUtil.IppStatusCode;
import com.xerox.IppUtil.ProgressObserverSupport;
import com.xerox.IppUtil.StreamingDoc;
import com.xerox.IppUtil.iDataOutputWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;

public class Client {
    private String printerURL = "";
    private String docToPrint = "";
    private String whichJobsValue = "";
    private String attrDataFileName = "";
    private String debugFileName = "";
    private String requestedAttrValue = null;
    private String jobTicketName = null;
    private int printJobType = 0;
    private static final int CHUNK_SIZE_ZERO = 0;
    private int chunkSize = 0;
    private static final int CONSOLE = 1;
    private static final int FILE = 2;
    private int operationID = 0;
    private static int debugLevel = 0;
    private int jobID = 0;
    private static int outputDestination = 1;
    private boolean attributeDisplay = true;
    private boolean observerOn = false;
    private IntervalTimer intervalTimer = new IntervalTimer();
    private IntervalTimer intervalTimer2 = new IntervalTimer();
    private boolean useTimer = true;
    private static iDataOutputWriter dow = null;
    private static final boolean DEFAULT_ACCEPT_CERTIFICATE = false;
    private boolean acceptCert = false;
    private static final short INSTALL_CERT_ID = 99;
    private static final String INSTALL_CERT_OPERATION_NAME = "Install Certificate";
    private static final String DEFAULT_DOC_TO_PRINT = "SimpleTest.txt";
    private String DEFAULT_ATTR_DATA_FILE_NAME = "StockLibrary.ini";
    private static final String DEFAULT_DEUG_FILE_NAME = "IppOps_Debug.txt";
    private static final String LOG_FILE_NAME = "IppOpsException.log";
    private static final String DEFAULT_PRINTER = "https://ccdt-tigris.ess.mc.xerox.com/servlet/IPPServlet.IppPrinter/default";
    private static final String DEFAULT_WHICH_JOBS_VALUE = "completed";
    private static final int SPOOL_PRINT_JOB = 1;
    private static final int STREAM_PRINT_JOB = 2;
    private static final int NO_JOB_ID = -1;
    private static final boolean EVENT_LOGGING_SWTICH = true;
    private static final int DEBUG_OFF = 0;
    private static final int DEBUG_1 = 1;
    private static final int DEBUG_2 = 2;
    private static final int DEBUG_3 = 3;
    private static final int DEBUG_4 = 4;
    private static final int DEBUG_5 = 5;
    private static final int DEBUG_6 = 6;
    private static final int DEBUG_DEFAULT = 2;
    private static final int DEBUG_MAX = 6;
    private static final boolean NAME_ONLY = true;
    private static final boolean NAME_AND_VALUE = false;
    private static final boolean TIMER_ON = true;
    private static final boolean TIMER_OFF = false;
    private static final String ON_STRING = "on";
    private static final String STAR_BAR_60 = "*******************************************************";
    private static final String SUBMITTING_TO_API = "Client is Submitting the request to the Printer ";
    private static final String WAITING = "  Waiting for a response ...... ";
    private static final String WITH_JT = "  with job ticket -  ";
    private static final String JT_REF_ATTACHED = "    Job Ticket reference is attached ";
    private static final String JT_FILE_NAME = "    Job Ticket file name -  ";
    private static final String OP_REQUEST_EXECUTED = "  ...... the Ipp Opertion Request was executed";
    private static final String APP_NAME_COPYRIGHT = "Ipp Ops API Client - copyright (c) 2002 Xerox Corp";
    private static final String CONTACT_INFO = "For help contact gary.pecor@usa.xerox.com";
    private static final String CODEX_DOWNLOAD = "This client can be down loaded from - http://codex.xerox.com/projects/ippopsapi";
    private iAttribute jobURI = null;
    private static iValueElementFactory veFactory = new ValueElementFactory();
    public static IppObject io1_debug;

    public static void main(String[] stringArray) {
        System.setProperty("certpw", "changeit");
        Client client = new Client();
        if (client.processCmdLineInput(stringArray)) {
            if (debugLevel >= 1 && outputDestination == 1) {
                System.out.println();
                System.out.println(APP_NAME_COPYRIGHT);
                System.out.println();
            }
            client.executeRequest();
        }
    }

    private void Client() {
    }

    private void executeRequest() {
        switch (this.operationID) {
            case 2: {
                this.printJob(this.printerURL, this.printJobType, this.docToPrint, this.jobTicketName);
                break;
            }
            case 11: {
                this.getPrinterAttributes(this.printerURL);
                break;
            }
            case 10: {
                this.getJobs(this.printerURL);
                break;
            }
            case 9: {
                this.getJobAttributes();
                break;
            }
            case 5: {
                this.createJob();
                break;
            }
            case 6: {
                this.sendDocument(this.printerURL, this.printJobType, this.docToPrint, this.jobID);
                break;
            }
            case 3: {
                break;
            }
            case 99: {
                this.installCertificate(this.acceptCert);
                break;
            }
            default: {
                System.out.println(" Unkown Operation ID = " + this.operationID);
                return;
            }
        }
    }

    private void printJob(String string, int n, String string2, String string3) {
        FileInputStream fileInputStream = null;
        StreamingDoc streamingDoc = null;
        if (debugLevel >= 1) {
            dow.print("Print-Job called");
            if (n == 2) {
                dow.println(" with Streaming");
            }
            dow.println();
        }
        iAttributeGroup iAttributeGroup2 = this.createOperationAttrGroup();
        this.addAdditionalPrintJobAttributesTo(iAttributeGroup2, string);
        OperationRequest operationRequest = new OperationRequest();
        operationRequest.setOperationAttrGroup(iAttributeGroup2);
        iAttributeGroup iAttributeGroup3 = this.createJobTemplateAttrGroup();
        if (string3 == null) {
            operationRequest.setJobTemplateAttrGroup(iAttributeGroup3);
        }
        if (n == 1) {
            operationRequest.setDocContent(string2);
        } else {
            try {
                fileInputStream = new FileInputStream(string2);
            }
            catch (Exception exception) {
                dow.println("EXCEPTION e CAUGHT when creating the FileInputStream ");
            }
            streamingDoc = new StreamingDoc(fileInputStream, this.chunkSize);
        }
        IppObjectConfig ippObjectConfig = new IppObjectConfig();
        ippObjectConfig.eventLoggingOn(true);
        CertificateAccept certificateAccept = new CertificateAccept(dow);
        ippObjectConfig.setUserAcceptCertificate((iCertificateAccept)certificateAccept);
        IppObjectPlus ippObjectPlus = new IppObjectPlus(ippObjectConfig);
        iOperationResponse iOperationResponse2 = null;
        int n2 = 1;
        for (int i = 0; i < n2; ++i) {
            this.displayOpRequestBeforeSending(operationRequest);
            this.intervalTimer.reset();
            try {
                if (n == 1) {
                    if (this.observerOn) {
                        this.intervalTimer.start();
                        ProgressObserverSupport progressObserverSupport = new ProgressObserverSupport();
                        iOperationResponse2 = ippObjectPlus.printJob(operationRequest, (iProgressObserverSupport)progressObserverSupport);
                        this.intervalTimer.stop();
                    } else if (string3 != null) {
                        this.intervalTimer.start();
                        iOperationResponse2 = ippObjectPlus.printJob(operationRequest, string3);
                        this.intervalTimer.stop();
                    } else {
                        this.intervalTimer.start();
                        iOperationResponse2 = ippObjectPlus.printJob(operationRequest);
                        this.intervalTimer.stop();
                    }
                } else {
                    this.intervalTimer.start();
                    this.intervalTimer.stop();
                }
            }
            catch (Exception exception) {
                this.printExceptionData(exception, OP_REQUEST_EXECUTED);
                iOperationResponse2 = this.getFailedOpResponse(exception);
            }
            this.readTheOpResponse(iOperationResponse2, ippObjectPlus.getEventLog());
        }
        ippObjectPlus.closeConnection();
        dow.close();
    }

    private void getPrinterAttributes(String string) {
        iAttributeGroup iAttributeGroup2 = this.createOperationAttrGroup();
        this.addAdditionalGetPrinterAttributesTo(iAttributeGroup2, string);
        OperationRequest operationRequest = new OperationRequest();
        operationRequest.setOperationAttrGroup(iAttributeGroup2);
        if (debugLevel >= 3) {
            Client.printContent(iAttributeGroup2, this.attributeDisplay, "Operation Attributes for Get-Printer-Attributes");
        }
        IppObjectConfig ippObjectConfig = new IppObjectConfig();
        ippObjectConfig.eventLoggingOn(true);
        CertificateAccept certificateAccept = new CertificateAccept();
        ippObjectConfig.setUserAcceptCertificate((iCertificateAccept)certificateAccept);
        IppObject ippObject = new IppObject(ippObjectConfig);
        iOperationResponse iOperationResponse2 = null;
        try {
            this.intervalTimer.start();
            iOperationResponse2 = ippObject.getPrinterAttributes(operationRequest);
            this.intervalTimer.stop();
        }
        catch (Exception exception) {
            if (debugLevel >= 1) {
                // empty if block
            }
            iOperationResponse2 = this.getFailedOpResponse(exception);
        }
        this.readTheOpResponse(iOperationResponse2, ippObject.getEventLog());
        ippObject.closeConnection();
        dow.close();
    }

    String getProcessingTime(iOperationResponse iOperationResponse2, String string, long l) {
        iAttributeGroup iAttributeGroup2 = iOperationResponse2.getPrinterAttributeGroup();
        iAttribute iAttribute2 = iAttributeGroup2.getAttribute(string);
        this.intervalTimer2.reset();
        this.intervalTimer2.start();
        for (long i = 0L; i < l; ++i) {
            iAttributeValue iAttributeValue2 = iAttribute2.getAttributeValue();
            iIntegerValue iIntegerValue2 = (iIntegerValue)iAttributeValue2.getValueElement(0);
            int n = iIntegerValue2.getValue();
        }
        this.intervalTimer2.stop();
        return this.intervalTimer2.getElaspedTime(1L);
    }

    private void getJobs(String string) {
        if (debugLevel >= 1) {
            dow.println("Get-Jobs called");
            dow.println("   " + string);
            dow.println();
        }
        iAttributeGroup iAttributeGroup2 = this.createOperationAttrGroup();
        this.addAdditionalGetJobsAttributesTo(iAttributeGroup2, string);
        OperationRequest operationRequest = new OperationRequest();
        operationRequest.setOperationAttrGroup(iAttributeGroup2);
        this.displayOpRequestBeforeSending(operationRequest);
        IppObject ippObject = new IppObject(true);
        iOperationResponse iOperationResponse2 = null;
        try {
            this.intervalTimer.start();
            iOperationResponse2 = ippObject.getJobs(operationRequest);
            this.intervalTimer.stop();
        }
        catch (Exception exception) {
            this.printExceptionData(exception, OP_REQUEST_EXECUTED);
            iOperationResponse2 = this.getFailedOpResponse(exception);
        }
        this.readTheOpResponse(iOperationResponse2, ippObject.getEventLog());
        ippObject.closeConnection();
        dow.close();
    }

    String getProcessingTimeJobData(iOperationResponse iOperationResponse2, long l) {
        String string = null;
        iStringValue iStringValue2 = null;
        long l2 = 0L;
        int n = 0;
        long l3 = 0L;
        iAttrGroupSet iAttrGroupSet2 = iOperationResponse2.getJobGroup();
        int n2 = iAttrGroupSet2.size();
        this.intervalTimer2.reset();
        this.intervalTimer2.start();
        l2 = System.currentTimeMillis();
        int n3 = 0;
        while ((long)n3 < l) {
            for (int i = 0; i < n2; ++i) {
                iAttributeGroup iAttributeGroup2 = iAttrGroupSet2.getAttrGroup(i);
                iAttribute iAttribute2 = iAttributeGroup2.getAttribute("job-id");
                iAttributeValue iAttributeValue2 = iAttribute2.getAttributeValue();
                iIntegerValue iIntegerValue2 = (iIntegerValue)iAttributeValue2.getValueElement(0);
                int n4 = iIntegerValue2.getValue();
                iAttribute2 = iAttributeGroup2.getAttribute("job-uri");
                iAttributeValue2 = iAttribute2.getAttributeValue();
                iStringValue2 = (iStringValue)iAttributeValue2.getValueElement(0);
                string = iStringValue2.getValue();
                iAttribute2 = iAttributeGroup2.getAttribute("job-originating-user-name");
                iAttributeValue2 = iAttribute2.getAttributeValue();
                iWithoutLangValue iWithoutLangValue2 = (iWithoutLangValue)iAttributeValue2.getValueElement(0);
                string = iWithoutLangValue2.getValue();
                iAttribute2 = iAttributeGroup2.getAttribute("date-time-at-creation");
                iAttributeValue2 = iAttribute2.getAttributeValue();
                iDateTimeValue iDateTimeValue2 = (iDateTimeValue)iAttributeValue2.getValueElement(0);
                n4 = iDateTimeValue2.getDate();
                n4 = iDateTimeValue2.getHour();
                n4 = iDateTimeValue2.getMinute();
                n4 = iDateTimeValue2.getSecond();
                n4 = iDateTimeValue2.getMonth();
                n4 = iDateTimeValue2.getYear();
                string = iDateTimeValue2.getStringValue();
                iAttribute2 = iAttributeGroup2.getAttribute("job-state");
                iAttributeValue2 = iAttribute2.getAttributeValue();
                iIntegerValue2 = (iIntegerValue)iAttributeValue2.getValueElement(0);
                n4 = iIntegerValue2.getValue();
                iAttribute2 = iAttributeGroup2.getAttribute("job-state-reasons");
                iAttributeValue2 = iAttribute2.getAttributeValue();
                int n5 = iAttributeValue2.size();
                for (n = 0; n < n5; ++n) {
                    iStringValue2 = (iStringValue)iAttributeValue2.getValueElement(0);
                    string = iStringValue2.getValue();
                }
                l3 = l3 + 11L + (long)n;
            }
            ++n3;
        }
        this.intervalTimer2.stop();
        System.out.println(" samples = " + l);
        System.out.println(" job count = " + n2);
        System.out.println(" # of values read = " + l3);
        long l4 = System.currentTimeMillis();
        long l5 = l4 - l2;
        float f = (float)l5 / (float)l3;
        System.out.println(" time in millis per value read = " + f);
        System.out.println(" elasped time  = " + l5);
        return this.intervalTimer2.getElaspedTime();
    }

    private void getJobAttributes() {
        if (debugLevel >= 1) {
            dow.println("Get-Job-Attributes called");
            dow.println("   " + this.printerURL);
            dow.println();
            if (this.jobID == -1) {
                dow.println("ERROR - No job ID has been specified for this request");
                dow.println();
            }
        }
        if (this.jobID == -1) {
            return;
        }
        iAttributeGroup iAttributeGroup2 = this.createOperationAttrGroup();
        this.addAdditionalGJAAttributesTo(iAttributeGroup2, this.printerURL);
        OperationRequest operationRequest = new OperationRequest();
        operationRequest.setOperationAttrGroup(iAttributeGroup2);
        this.displayOpRequestBeforeSending(operationRequest);
        IppObject ippObject = new IppObject(true);
        iOperationResponse iOperationResponse2 = null;
        try {
            if (debugLevel >= 1) {
                dow.println(SUBMITTING_TO_API);
                dow.println(WAITING);
                dow.println();
            }
            this.intervalTimer.start();
            iOperationResponse2 = ippObject.getJobAttributes(operationRequest);
            this.intervalTimer.stop();
        }
        catch (Exception exception) {
            this.printExceptionData(exception, OP_REQUEST_EXECUTED);
            iOperationResponse2 = this.getFailedOpResponse(exception);
        }
        this.readTheOpResponse(iOperationResponse2, ippObject.getEventLog());
        ippObject.closeConnection();
        dow.close();
    }

    private void createJob() {
        if (debugLevel >= 1) {
            dow.println("Create-Job called");
            dow.println("   " + this.printerURL);
            dow.println();
        }
        iAttributeGroup iAttributeGroup2 = this.createOperationAttrGroup();
        this.addAdditionalCreateJobAttributes(iAttributeGroup2, this.printerURL);
        OperationRequest operationRequest = new OperationRequest();
        operationRequest.setOperationAttrGroup(iAttributeGroup2);
        this.displayOpRequestBeforeSending(operationRequest);
        IppObject ippObject = new IppObject(true);
        iOperationResponse iOperationResponse2 = null;
        try {
            if (debugLevel >= 1) {
                dow.println(SUBMITTING_TO_API);
                dow.println(WAITING);
                dow.println();
            }
            this.intervalTimer.start();
            iOperationResponse2 = ippObject.createJob(operationRequest);
            this.intervalTimer.stop();
        }
        catch (Exception exception) {
            this.printExceptionData(exception, OP_REQUEST_EXECUTED);
            iOperationResponse2 = this.getFailedOpResponse(exception);
        }
        this.readTheOpResponse(iOperationResponse2, ippObject.getEventLog());
        this.sendDocumentToPrinter(iOperationResponse2, this.printerURL, this.printJobType, this.docToPrint);
        dow.close();
    }

    private void sendDocument(String string, int n, String string2, int n2) {
        FileInputStream fileInputStream = null;
        StreamingDoc streamingDoc = null;
        if (debugLevel >= 1) {
            dow.print("Send-Document called");
            if (n == 2) {
                dow.println(" with Streaming");
            }
            dow.println();
        }
        iAttributeGroup iAttributeGroup2 = this.createOperationAttrGroup();
        this.addAdditionalSendDocumentAttributes(iAttributeGroup2, string, n2);
        OperationRequest operationRequest = new OperationRequest();
        operationRequest.setOperationAttrGroup(iAttributeGroup2);
        if (n == 1) {
            operationRequest.setDocContent(string2);
        } else {
            try {
                fileInputStream = new FileInputStream(string2);
            }
            catch (Exception exception) {
                dow.println("EXCEPTION e CAUGHT when creating the FileInputStream ");
            }
            streamingDoc = new StreamingDoc(fileInputStream, this.chunkSize);
        }
        this.displayOpRequestBeforeSending(operationRequest);
        IppObjectPlus ippObjectPlus = new IppObjectPlus(true);
        iOperationResponse iOperationResponse2 = null;
        try {
            if (debugLevel >= 1) {
                dow.println(SUBMITTING_TO_API);
                dow.println(WAITING);
                dow.println();
            }
            if (n == 1) {
                this.intervalTimer.start();
                iOperationResponse2 = ippObjectPlus.sendDocument(operationRequest);
                this.intervalTimer.stop();
            } else {
                this.intervalTimer.start();
                this.intervalTimer.stop();
            }
        }
        catch (Exception exception) {
            this.printExceptionData(exception, OP_REQUEST_EXECUTED);
            iOperationResponse2 = this.getFailedOpResponse(exception);
        }
        this.readTheOpResponse(iOperationResponse2, ippObjectPlus.getEventLog());
        ippObjectPlus.closeConnection();
        dow.close();
    }

    private void installCertificate(boolean bl) {
        this.requestedAttrValue = "printer-make-and-model";
        if (debugLevel >= 1) {
            dow.println("Install Certificate called for printer:");
            dow.println("   " + this.printerURL);
            dow.println();
            dow.println("   Cacert Path     = " + System.getProperty("certpath"));
            dow.println("   Cacert password = " + System.getProperty("certpw"));
        }
        iAttributeGroup iAttributeGroup2 = this.createOperationAttrGroup();
        this.addAdditionalGetPrinterAttributesTo(iAttributeGroup2, this.printerURL);
        OperationRequest operationRequest = new OperationRequest();
        operationRequest.setOperationAttrGroup(iAttributeGroup2);
        if (debugLevel >= 3) {
            Client.printContent(iAttributeGroup2, this.attributeDisplay, "Operation Attributes for Get-Printer-Attributes");
        }
        IppObjectConfig ippObjectConfig = new IppObjectConfig();
        ippObjectConfig.eventLoggingOn(true);
        CertificateAccept certificateAccept = new CertificateAccept();
        certificateAccept.setAcceptance(bl);
        ippObjectConfig.setUserAcceptCertificate((iCertificateAccept)certificateAccept);
        IppObject ippObject = new IppObject(ippObjectConfig);
        iOperationResponse iOperationResponse2 = null;
        try {
            if (debugLevel >= 1) {
                dow.println(SUBMITTING_TO_API);
                dow.println(WAITING);
                dow.println();
            }
            this.intervalTimer.start();
            iOperationResponse2 = ippObject.getPrinterAttributes(operationRequest);
            this.intervalTimer.stop();
        }
        catch (Exception exception) {
            if (debugLevel >= 1) {
                this.printExceptionData(exception, OP_REQUEST_EXECUTED);
            }
            iOperationResponse2 = this.getFailedOpResponse(exception);
        }
        this.readTheOpResponse(iOperationResponse2, ippObject.getEventLog());
        ippObject.closeConnection();
        dow.close();
    }

    private void sendDocumentToPrinter(iOperationResponse iOperationResponse2, String string, int n, String string2) {
        iAttrGroupSet iAttrGroupSet2 = iOperationResponse2.getJobGroup();
        if (iAttrGroupSet2 != null) {
            iAttributeGroup iAttributeGroup2 = iAttrGroupSet2.getAttrGroup(0);
            iAttribute iAttribute2 = null;
            try {
                iAttribute2 = iAttributeGroup2.getAttribute("job-id");
                this.jobURI = iAttributeGroup2.getAttribute("job-uri");
            }
            catch (Exception exception) {
                this.printExceptionData(exception, "getting the job-id attribute from the operation response");
                return;
            }
            iAttributeValue iAttributeValue2 = iAttribute2.getAttributeValue();
            iIntegerValue iIntegerValue2 = (iIntegerValue)iAttributeValue2.getValueElement(0);
            int n2 = iIntegerValue2.getValue();
            this.operationID = 6;
            if (debugLevel >= 2) {
                this.displayArgs();
            }
            this.sendDocument(string, n, string2, n2);
        }
    }

    private iAttributeGroup createOperationAttrGroup() {
        AttributeGroup attributeGroup = new AttributeGroup();
        iStringValue iStringValue2 = veFactory.makeCharsetValue("utf-8");
        AttributeValue attributeValue = new AttributeValue((iValueElement)iStringValue2);
        Attribute attribute = new Attribute("attributes-charset", (iAttributeValue)attributeValue);
        attributeGroup.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeNaturalLangValue("en-us");
        attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("attributes-natural-language", (iAttributeValue)attributeValue);
        attributeGroup.addAttribute((iAttribute)attribute);
        return attributeGroup;
    }

    private iAttributeGroup createJobTemplateAttrGroup() {
        AttributeGroup attributeGroup = new AttributeGroup();
        iIntegerValue iIntegerValue2 = veFactory.makeIntegerValue(2);
        AttributeValue attributeValue = new AttributeValue((iValueElement)iIntegerValue2);
        Attribute attribute = new Attribute("copies", (iAttributeValue)attributeValue);
        attributeGroup.addAttribute((iAttribute)attribute);
        iIntegerValue2 = veFactory.makeKeywordValue("one-sided");
        attributeValue = new AttributeValue((iValueElement)iIntegerValue2);
        attribute = new Attribute("sides", (iAttributeValue)attributeValue);
        attributeGroup.addAttribute((iAttribute)attribute);
        iIntegerValue2 = veFactory.makeEnumValue("20");
        attributeValue = new AttributeValue((iValueElement)iIntegerValue2);
        attribute = new Attribute("finishings", (iAttributeValue)attributeValue);
        return attributeGroup;
    }

    iAttribute makeCollection() {
        CollectionValue collectionValue = new CollectionValue();
        AttributeValue attributeValue = new AttributeValue((iValueElement)collectionValue);
        Attribute attribute = new Attribute("separator-sheets", (iAttributeValue)attributeValue);
        iStringValue iStringValue2 = veFactory.makeKeywordValue("none");
        AttributeValue attributeValue2 = new AttributeValue((iValueElement)iStringValue2);
        Attribute attribute2 = new Attribute("separator-sheets-type", (iAttributeValue)attributeValue2);
        collectionValue.addAttribute((iAttribute)attribute2);
        collectionValue.addAttribute(this.makeMediaColAttribute());
        return attribute;
    }

    iAttribute makeMediaColAttribute() {
        CollectionValue collectionValue = new CollectionValue();
        Attribute attribute = new Attribute("media-col", (iValueElement)collectionValue);
        Attribute attribute2 = new Attribute("media-description", (iValueElement)veFactory.makeNameWithLangValue("default", "en-us"));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("media-color", (iValueElement)veFactory.makeKeywordValue("red"));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("media-type", (iValueElement)veFactory.makeKeywordValue("pre-cut-tabs"));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("media-pre-printed", (iValueElement)veFactory.makeKeywordValue("pre-printed"));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("media-hole-count", (iValueElement)veFactory.makeIntegerValue(0));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("media-order-count", (iValueElement)veFactory.makeIntegerValue(0));
        collectionValue.addAttribute((iAttribute)attribute2);
        CollectionValue collectionValue2 = new CollectionValue();
        Attribute attribute3 = new Attribute("media-size", (iValueElement)collectionValue2);
        collectionValue.addAttribute((iAttribute)attribute3);
        attribute2 = new Attribute("x-dimension", (iValueElement)veFactory.makeIntegerValue(21000));
        collectionValue2.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("y-dimension", (iValueElement)veFactory.makeIntegerValue(21600));
        collectionValue2.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("media-weight-metric", (iValueElement)veFactory.makeIntegerValue(75));
        collectionValue.addAttribute((iAttribute)attribute2);
        return attribute;
    }

    iAttribute makeInsertSheetAttribute() {
        CollectionValue collectionValue = new CollectionValue();
        Attribute attribute = new Attribute("insert-sheet", (iValueElement)collectionValue);
        iAttributeValue iAttributeValue2 = attribute.getAttributeValue();
        Attribute attribute2 = new Attribute("insert-after-page-number", (iValueElement)veFactory.makeIntegerValue(1));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("insert-count", (iValueElement)veFactory.makeIntegerValue(1));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("media", (iValueElement)veFactory.makeKeywordValue("default"));
        collectionValue.addAttribute((iAttribute)attribute2);
        collectionValue = new CollectionValue();
        attribute2 = new Attribute("insert-after-page-number", (iValueElement)veFactory.makeIntegerValue(2));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("insert-count", (iValueElement)veFactory.makeIntegerValue(1));
        collectionValue.addAttribute((iAttribute)attribute2);
        collectionValue.addAttribute(this.makeMediaColAttribute());
        iAttributeValue2.addValueElement((iValueElement)collectionValue);
        collectionValue = new CollectionValue();
        attribute2 = new Attribute("insert-after-page-number", (iValueElement)veFactory.makeIntegerValue(3));
        collectionValue.addAttribute((iAttribute)attribute2);
        attribute2 = new Attribute("insert-count", (iValueElement)veFactory.makeIntegerValue(1));
        collectionValue.addAttribute((iAttribute)attribute2);
        collectionValue.addAttribute(this.makeMediaColAttribute());
        iAttributeValue2.addValueElement((iValueElement)collectionValue);
        return attribute;
    }

    public iAttribute createRequestedAttribute() {
        iStringValue iStringValue2 = veFactory.makeKeywordValue("printer-make-and-model");
        AttributeValue attributeValue = new AttributeValue((iValueElement)iStringValue2);
        Attribute attribute = new Attribute("requested-attributes", (iAttributeValue)attributeValue);
        attributeValue.addValueElement((iValueElement)veFactory.makeKeywordValue("printer-uri-supported"));
        attributeValue.addValueElement((iValueElement)veFactory.makeKeywordValue("uri-security-supported"));
        attributeValue.addValueElement((iValueElement)veFactory.makeKeywordValue("printer-name"));
        attributeValue.addValueElement((iValueElement)veFactory.makeKeywordValue("media-col-database"));
        return attribute;
    }

    void addAdditionalGetPrinterAttributesTo(iAttributeGroup iAttributeGroup2, String string) {
        iStringValue iStringValue2 = veFactory.makeURIValue(string);
        Attribute attribute = new Attribute("printer-uri", (iValueElement)iStringValue2);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        if (this.requestedAttrValue == null) {
            this.requestedAttrValue = "all";
        }
        iAttributeGroup2.addAttribute(this.createRequestedAttribute());
        iStringValue2 = veFactory.makeMimeMediaTypeValue("application/octet-stream");
        AttributeValue attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("document-format", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
    }

    void addAdditionalPrintJobAttributesTo(iAttributeGroup iAttributeGroup2, String string) {
        iStringValue iStringValue2 = veFactory.makeURIValue(string);
        Attribute attribute = new Attribute("printer-uri", (iValueElement)iStringValue2);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeNameWithLangValue("IppOps API User", "en-us");
        AttributeValue attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("requesting-user-name", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeNameWithLangValue("IppOps job-name", "en-us");
        attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("job-name", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
    }

    void addAdditionalCreateJobAttributes(iAttributeGroup iAttributeGroup2, String string) {
        iStringValue iStringValue2 = veFactory.makeURIValue(string);
        Attribute attribute = new Attribute("printer-uri", (iValueElement)iStringValue2);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeNameWithoutLangValue("IppOps API User");
        AttributeValue attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("requesting-user-name", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeNameWithoutLangValue("IppOps create-job-test");
        attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("job-name", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
    }

    void addAdditionalSendDocumentAttributes(iAttributeGroup iAttributeGroup2, String string, int n) {
        iStringValue iStringValue2 = veFactory.makeURIValue(string);
        Attribute attribute = new Attribute("printer-uri", (iValueElement)iStringValue2);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeIntegerValue(n);
        attribute = new Attribute("job-id", (iValueElement)iStringValue2);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeNameWithoutLangValue("IppOps API User");
        AttributeValue attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("requesting-user-name", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeNameWithoutLangValue(this.docToPrint);
        attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("document-name", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeMimeMediaTypeValue("application/octet-stream");
        attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("document-format", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeBooleanValue(true);
        attribute = new Attribute("last-document", (iValueElement)iStringValue2);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
    }

    private void addAdditionalGetJobsAttributesTo(iAttributeGroup iAttributeGroup2, String string) {
        iStringValue iStringValue2 = veFactory.makeURIValue(string);
        Attribute attribute = new Attribute("printer-uri", (iValueElement)iStringValue2);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeNameWithoutLangValue("IppOps API User");
        AttributeValue attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("requesting-user-name", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeKeywordValue("job-id");
        attributeValue = new AttributeValue((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-name");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-uri");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-originating-user-name");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("date-time-at-creation");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-state");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-state-reasons");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        attribute = new Attribute("requested-attributes", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        if (this.requestedAttrValue != null) {
            iStringValue2 = veFactory.makeKeywordValue(this.requestedAttrValue);
            attributeValue.addValueElement((iValueElement)iStringValue2);
        }
        iStringValue2 = veFactory.makeKeywordValue(this.whichJobsValue);
        attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("which-jobs", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
    }

    private void addAdditionalGJAAttributesTo(iAttributeGroup iAttributeGroup2, String string) {
        iStringValue iStringValue2 = veFactory.makeURIValue(string);
        Attribute attribute = new Attribute("printer-uri", (iValueElement)iStringValue2);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeIntegerValue(this.jobID);
        AttributeValue attributeValue = new AttributeValue((iValueElement)iStringValue2);
        attribute = new Attribute("job-id", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        iStringValue2 = veFactory.makeKeywordValue("job-id");
        attributeValue = new AttributeValue((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-name");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-uri");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-originating-user-name");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("date-time-at-creation");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-state");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        iStringValue2 = veFactory.makeKeywordValue("job-state-reasons");
        attributeValue.addValueElement((iValueElement)iStringValue2);
        attribute = new Attribute("requested-attributes", (iAttributeValue)attributeValue);
        iAttributeGroup2.addAttribute((iAttribute)attribute);
        if (this.requestedAttrValue != null) {
            iStringValue2 = veFactory.makeKeywordValue(this.requestedAttrValue);
            attributeValue.addValueElement((iValueElement)iStringValue2);
        }
    }

    private void displayOpRequestBeforeSending(OperationRequest operationRequest) {
        if (debugLevel == 0) {
            return;
        }
        if (debugLevel >= 3) {
            dow.println("Display the Operation Request before sending:");
            iAttributeGroup iAttributeGroup2 = operationRequest.getOperationAttrGroup();
            Client.printContent(iAttributeGroup2, this.attributeDisplay, "Request Operation Attribute Group");
            iAttributeGroup iAttributeGroup3 = operationRequest.getJobTemplateAttrGroup();
            if (iAttributeGroup3 != null) {
                Client.printContent(iAttributeGroup3, this.attributeDisplay, "Job Template Attribute Group");
            }
        }
    }

    void readTheOpResponse(iOperationResponse iOperationResponse2, iEventLog iEventLog2) {
        int n;
        int n2;
        iAttributeGroup iAttributeGroup2;
        if (debugLevel == 0) {
            return;
        }
        IppStatusCode ippStatusCode = new IppStatusCode(iOperationResponse2.getIppStatusCode());
        int n3 = iEventLog2.errorEventCount() + iEventLog2.warningEventCount();
        if (debugLevel >= 1) {
            // empty if block
        }
        iAttributeGroup iAttributeGroup3 = iOperationResponse2.getOperationAttributeGroup();
        iAttributeGroup iAttributeGroup4 = iOperationResponse2.getUnsupportedAttributeGroup();
        iAttributeGroup iAttributeGroup5 = iOperationResponse2.getPrinterAttributeGroup();
        iAttrGroupSet iAttrGroupSet2 = iOperationResponse2.getJobGroup();
        if (debugLevel >= 3 && debugLevel <= 5) {
            if (n3 > 0) {
                // empty if block
            }
            if (iAttributeGroup3 != null) {
                Client.printContent(iAttributeGroup3, this.attributeDisplay, "Operation Attribute Group");
            }
            if (iAttributeGroup4 != null) {
                Client.printContent(iAttributeGroup4, this.attributeDisplay, "Unsupported Attribute Group");
            }
            if (iAttributeGroup5 != null) {
                Client.printContent(iAttributeGroup5, this.attributeDisplay, "Printer Attribute Group");
            }
            iAttributeGroup2 = null;
            if (iAttrGroupSet2 != null) {
                n2 = iAttrGroupSet2.size();
                if (n2 > 0) {
                    for (n = 0; n < n2; ++n) {
                        iAttributeGroup2 = iAttrGroupSet2.getAttrGroup(n);
                        Client.printContent(iAttributeGroup2, this.attributeDisplay, "Job Attribute Group");
                    }
                }
                dow.println();
                dow.println("  Job count = " + n2);
            }
        }
        if (debugLevel == 6) {
            if (iEventLog2.size() > 0) {
                // empty if block
            }
            if (iAttributeGroup3 != null) {
                Client.printContent(iAttributeGroup3, this.attributeDisplay, "Operation Attribute Group");
                Client.printAttributeNameList(iAttributeGroup3, "Operation Attribute Group");
            }
            if (iAttributeGroup4 != null) {
                Client.printContent(iAttributeGroup4, this.attributeDisplay, "Unsupported Attribute Group");
                Client.printAttributeNameList(iAttributeGroup4, "Unsupported Attribute Group");
            }
            if (iAttributeGroup5 != null) {
                Client.printContent(iAttributeGroup5, this.attributeDisplay, "Printer Attribute Group");
                Client.printAttributeNameList(iAttributeGroup5, "Printer Attribute Group");
            } else if (iAttrGroupSet2 == null) {
                dow.println("  Operation Response does not contain a Printer Attribute Group");
            }
            iAttributeGroup2 = null;
            if (iAttrGroupSet2 != null) {
                n2 = iAttrGroupSet2.size();
                if (n2 > 0) {
                    for (n = 0; n < n2; ++n) {
                        iAttributeGroup2 = iAttrGroupSet2.getAttrGroup(n);
                        Client.printContent(iAttributeGroup2, this.attributeDisplay, "Job Attribute Group");
                        Client.printAttributeNameList(iAttributeGroup2, "Job Attribute Group");
                    }
                }
                dow.println();
                dow.println("  Job count = " + n2);
            }
        }
    }

    private boolean processCmdLineInput(String[] stringArray) {
        Object object;
        int n = 2;
        this.docToPrint = DEFAULT_DOC_TO_PRINT;
        this.printJobType = 1;
        this.printerURL = DEFAULT_PRINTER;
        this.whichJobsValue = DEFAULT_WHICH_JOBS_VALUE;
        this.jobID = -1;
        this.requestedAttrValue = null;
        debugLevel = 2;
        this.attributeDisplay = true;
        boolean bl = false;
        char c = 'z';
        boolean bl2 = false;
        int n2 = stringArray.length - 1;
        if (n2 == 0) {
            System.out.println("No Client Command Line Arguements were entered.");
            this.displayOperationChoices();
            return false;
        }
        try {
            this.operationID = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            System.out.println("The first arguement must be an Ipp Operation ID integer value");
            this.displayOperationChoices();
            return false;
        }
        if (n2 >= 1) {
            for (int i = 1; i < n2; ++i) {
                object = stringArray[i];
                char c2 = ((String)object).charAt(0);
                Character c3 = new Character(c2);
                Character c4 = new Character('-');
                if (i == 1) {
                    if (c3.compareTo(c4) == 0) {
                        if (((String)object).length() == n) {
                            c = ((String)object).charAt(1);
                            bl2 = true;
                            continue;
                        }
                        System.out.println("Option Switch arguement error!");
                        this.displayOperationChoices();
                        return false;
                    }
                    bl = true;
                    bl2 = false;
                    this.printerURL = object;
                    continue;
                }
                if (bl2) {
                    Object object2 = object;
                    bl2 = false;
                    this.processTheOptionSwtich(c, (String)object2);
                    continue;
                }
                if (c3.compareTo(c4) == 0) {
                    c = ((String)object).charAt(1);
                    bl2 = true;
                    continue;
                }
                System.out.println(" - option prefix not specified in the paramter ");
                this.displayOperationChoices();
                return false;
            }
        }
        String string = stringArray[n2];
        if (outputDestination == 2) {
            object = new File(string);
            dow = new DataOutputWriter((File)object);
        } else {
            dow = new DataOutputWriter(System.out);
        }
        if (debugLevel >= 2) {
            // empty if block
        }
        return true;
    }

    private void processTheOptionSwtich(char c, String string) {
        switch (c) {
            case 'a': {
                int n = Integer.parseInt(string);
                if (n == 1) {
                    this.acceptCert = true;
                    break;
                }
                this.acceptCert = false;
                break;
            }
            case 'c': {
                this.chunkSize = Integer.parseInt(string);
                if (this.chunkSize < 0) {
                    this.chunkSize = 0;
                }
                this.printJobType = 2;
                break;
            }
            case 'r': {
                this.requestedAttrValue = string;
                break;
            }
            case 's': {
                int n = Integer.parseInt(string);
                if (n == 1) {
                    this.printJobType = 1;
                    break;
                }
                if (n == 2) {
                    this.printJobType = 2;
                    break;
                }
                this.printJobType = 1;
                break;
            }
            case 'j': {
                this.jobID = Integer.parseInt(string);
                break;
            }
            case 'd': {
                this.docToPrint = string;
                break;
            }
            case 'l': {
                int n = Integer.parseInt(string);
                debugLevel = n < 0 || n > 6 ? 2 : n;
                if (debugLevel >= 4) {
                    this.attributeDisplay = false;
                    break;
                }
                this.attributeDisplay = true;
                break;
            }
            case 'o': {
                outputDestination = Integer.parseInt(string);
                if (outputDestination == 2) break;
                outputDestination = 1;
                break;
            }
            case 't': {
                this.jobTicketName = string;
                break;
            }
            case 'w': {
                this.whichJobsValue = string;
                break;
            }
            default: {
                break;
            }
            case 'x': {
                if (string == null) break;
                int n = Integer.parseInt(string);
                this.observerOn = n > 0;
            }
        }
    }

    private void displayOperationChoices() {
        System.out.println();
        System.out.println("Command line format to execute an Ipp Operation is:");
        System.out.println();
        System.out.println("  Client [Operation ID] [Printer URL] [-d] [-s] [-j] [-l]");
        System.out.println();
        System.out.println("  Supported Ipp Operations [Operation ID] are:");
        System.out.println("     Create Job             5   -l [] -o []");
        System.out.println("     Get Jobs               10  -l [] -o [] -w []");
        System.out.println("     Get Job Attributes     9   -j [] -l [] -o [] -r []");
        System.out.println("     Get Printer Attributes 11  -l [] -o [] -r []");
        System.out.println("     Print Job              2   -c [] -d [] -l [] -o [] -s [] -t [] -x []");
        System.out.println("     Send Document          6   -c [] -d [] -l [] -o [] -s [] -x []");
        System.out.println("     Install Certificate    99  -a [] -l [] -o []");
        System.out.println();
        System.out.println("  [Printer URL] is a valid argument for all requests and ");
        System.out.println("                does not require an option switch prefix");
        System.out.println();
        System.out.println("  Option Switches:");
        System.out.println("  -a  [0, 1] accept certificate, default setting is: No");
        System.out.println("         0 = No");
        System.out.println("         1 = Yes");
        System.out.println("  -c  [chunk size]");
        System.out.println("      Specify the streaming document chunk size in bytes.");
        System.out.println("      This switch automatically turns on the streaming option.");
        System.out.println("      It is not necessary to use the -s option switch when the ");
        System.out.println("      -c option switch is used.");
        System.out.println("  -d  [Document Path and Name]");
        System.out.println("  -j  [dddd]     numeric Job ID");
        System.out.println("  -l  [0...4]    level of debug display");
        System.out.println("         0 = none");
        System.out.println("         1 = user status info");
        System.out.println("         2 = high level debug messages");
        System.out.println("         3 = list attributes by name only");
        System.out.println("         4 = list attributes with name, syntax, and value");
        System.out.println("         6 = event log content will always be displayed");
        System.out.println("  -o  [1...2] the Output Destination can be either the console");
        System.out.println("      window or a file.");
        System.out.println("         1 = output to console window");
        System.out.println("         2 = output to the file - IppOps_Output.txt");
        System.out.println("         The file will be located in the current workking dir");
        System.out.println("  -r  [keyword] the requested-attribute value is a keyword");
        System.out.println("      that can be any single attribute name.  Or, it can");
        System.out.println("      be a group of attributes specified by one of the");
        System.out.println("      following keywords: [job-template],");
        System.out.println("      [printer-description], or [all]");
        System.out.println("  -s  [1...2] document send type, default is Spooling");
        System.out.println("         1 = Spooling");
        System.out.println("         2 = Streaming");
        System.out.println("  -t  [job ticket file name] the path an file name for the job");
        System.out.println("      ticket file to be used in the Print-Job operation");
        System.out.println("  -w  [keyword]");
        System.out.println("        any valid keyword defined for the which-jobs");
        System.out.println("        attribute, for example:");
        System.out.println("           [completed]");
        System.out.println("           [not-completed]");
        System.out.println("           [pending]");
        System.out.println("           [canceled]");
        System.out.println("           [all]");
        System.out.println("  -x  [0...1] switch on the Progress Observer for ");
        System.out.println("         a print-job with an attached document");
        System.out.println("         0 = Progress Observer Off");
        System.out.println("         1 = Progress Observer On");
        System.out.println();
        System.out.println("  Example:");
        System.out.println("     Client 2 [printer-url] -s 1 -l 3 -d d:\\work\\test.ps");
    }

    private void displayStartUpInfo() {
        dow.println(APP_NAME_COPYRIGHT);
        dow.println(IppObject.getVersion());
        dow.println(CONTACT_INFO);
        dow.println(CODEX_DOWNLOAD);
        dow.println();
    }

    private void displayArgs() {
        dow.println("Ipp Operation Request Starts here:");
        dow.println("  operationID  = " + this.operationID);
        dow.println("  target printer - " + this.printerURL);
        if (this.operationID == 2) {
            dow.print("  printJobType = " + this.printJobType);
            if (this.printJobType == 1) {
                dow.println(",  spooling");
            }
            if (this.printJobType == 2) {
                dow.println(",  streaming");
                dow.print("    chunk size = ");
                if (this.chunkSize == 0) {
                    dow.println(" default");
                } else {
                    dow.println(this.chunkSize);
                }
            }
            dow.println(this.docToPrint);
            if (this.jobTicketName != null) {
                dow.println(JT_REF_ATTACHED);
                dow.print(JT_FILE_NAME);
                dow.println(this.jobTicketName);
            }
        }
        dow.println("debugLevel   = " + debugLevel);
        dow.print("Output Destination is the ");
        if (outputDestination == 2) {
            dow.print("file - ");
            dow.println(this.DEFAULT_ATTR_DATA_FILE_NAME);
        } else {
            dow.println("Console Window");
        }
        dow.println("");
        dow.flush();
    }

    void printEventLogContents(iEventLog iEventLog2) {
        dow.println(STAR_BAR_60);
        dow.println("* Event Log Contents:");
        int n = iEventLog2.errorEventCount() + iEventLog2.warningEventCount();
        dow.println("*    - No. of Warning Events  - " + iEventLog2.warningEventCount());
        dow.println("*    - No. of Error Events    - " + iEventLog2.errorEventCount());
        dow.println("*    - Total No. of entries   - " + iEventLog2.size());
        dow.println("*");
        Object object = null;
        while (iEventLog2.hasNext()) {
            object = iEventLog2.next();
            if (object instanceof String) {
                dow.println("* " + object.toString());
                dow.println("*");
                continue;
            }
            if (!(object instanceof EventRecord)) continue;
            EventRecord eventRecord = (EventRecord)object;
            dow.println("* " + eventRecord.getTypeName());
            Object object2 = null;
            while (eventRecord.hasNext()) {
                object2 = eventRecord.next();
                dow.println("*    - " + object2.toString());
            }
            dow.println("*");
        }
        dow.println("*");
        dow.println("* End of Event Log");
        dow.println(STAR_BAR_60);
        dow.println();
    }

    iOperationResponse getFailedOpResponse(Exception exception) {
        EventLog eventLog = new EventLog();
        EventRecord eventRecord = new EventRecord(3, (Object)"Ipp Operation not completed");
        eventRecord.add((Object)"Caught the following Exception:");
        eventRecord.add((Object)exception);
        eventLog.add(eventRecord);
        OperationResponse operationResponse = new OperationResponse();
        operationResponse.setIppStatusCode(1536);
        return operationResponse;
    }

    void printExceptionData(Exception exception, String string) {
        dow.println("Exception caught by the Client when " + string);
        dow.println("e.getMessage() = " + exception.getMessage());
        dow.println("e.toString() = " + exception.toString());
        dow.println();
        dow.println(" *********  Start of stack trace *******");
        try {
            Client.writeStackTrace(exception);
        }
        catch (Exception exception2) {
            dow.println("Excepton caught processing an exception");
            return;
        }
        Throwable throwable = ((ChainedException)exception).getCause();
        dow.println(throwable.toString());
    }

    static void writeStackTrace(Throwable throwable) throws IOException {
        File file = new File(LOG_FILE_NAME);
        FileWriter fileWriter = new FileWriter(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        fileWriter.write(byteArrayOutputStream.toString());
        fileWriter.flush();
        dow.println(byteArrayOutputStream.toString());
    }

    public static void printContent(iAttributeGroup iAttributeGroup2, boolean bl, String string) {
        int n = bl ? 0 : 1;
        dow.printContent(iAttributeGroup2, n, string);
    }

    public static void printContent(iAttributeGroup iAttributeGroup2, boolean bl) {
        int n = bl ? 0 : 1;
        dow.printContent(iAttributeGroup2, n, null);
    }

    public static void printAttributeNameList(iAttributeGroup iAttributeGroup2, String string) {
        dow.printAttributeNameList(iAttributeGroup2);
    }
}

