/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.IppData;

import com.xerox.IppOps.DelimiterTag;
import com.xerox.IppOps.Group;
import com.xerox.IppOps.iAttribute;
import com.xerox.IppOps.iAttributeGroup;
import com.xerox.IppOps.iSimpleIterator;
import java.util.HashMap;
import java.util.Set;

public class AttributeGroup
extends Group
implements iAttributeGroup {
    private int modCountWhenLookUpWasCreated = 0;
    private HashMap nameLookUpTable = null;
    private byte groupTag;
    private String name = "";

    public AttributeGroup() {
        this.groupTag = (byte)15;
    }

    public AttributeGroup(String string) {
        this.groupTag = (byte)15;
        this.name = string == null ? "" : string;
    }

    public AttributeGroup(byte by) {
        this.groupTag = by;
        this.name = DelimiterTag.getTagName((byte)by);
    }

    public int size() {
        return super.size();
    }

    public byte getGroupTag() {
        return this.groupTag;
    }

    public void addAttribute(iAttribute iAttribute2) {
        super.addObject((Object)iAttribute2);
    }

    public iAttribute getAttribute(int n) {
        return (iAttribute)super.get(n);
    }

    public iAttribute getAttribute(String string) {
        if (this.modCountWhenLookUpWasCreated != this.getModCount()) {
            this.nameLookUpTable = this.makeAttrNameLookUpTable();
        } else if (this.nameLookUpTable == null) {
            throw new IllegalArgumentException("E103 - The requested Attribute does not exit - " + string);
        }
        iAttribute iAttribute2 = (iAttribute)this.nameLookUpTable.get(string);
        if (iAttribute2 == null) {
            throw new IllegalArgumentException("E103 - The requested Attribute does not exit - " + string);
        }
        return iAttribute2;
    }

    public boolean removeAttribute(iAttribute iAttribute2) {
        return super.remove((Object)iAttribute2);
    }

    public iAttributeGroup copy() {
        AttributeGroup attributeGroup = new AttributeGroup(this.groupTag);
        attributeGroup.setName(this.name);
        iSimpleIterator iSimpleIterator2 = this.iterator();
        while (iSimpleIterator2.hasNext()) {
            iAttribute iAttribute2 = ((iAttribute)iSimpleIterator2.next()).copy();
            attributeGroup.addAttribute(iAttribute2);
        }
        return attributeGroup;
    }

    public void setName(String string) {
        this.name = string == null ? "" : string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void add(Object object) throws IllegalArgumentException {
        if (!(object instanceof iAttribute)) {
            throw new IllegalArgumentException();
        }
        super.addObject(object);
    }

    public String[] getListOfAttributeNames() {
        if (this.modCountWhenLookUpWasCreated != this.getModCount()) {
            this.nameLookUpTable = this.makeAttrNameLookUpTable();
        } else if (this.nameLookUpTable == null) {
            String[] stringArray = new String[]{""};
            return stringArray;
        }
        Set set = this.nameLookUpTable.keySet();
        String[] stringArray = new String[set.size()];
        stringArray = set.toArray(stringArray);
        return stringArray;
    }

    public boolean containsAttribute(String string) {
        if (this.modCountWhenLookUpWasCreated != this.getModCount()) {
            this.nameLookUpTable = this.makeAttrNameLookUpTable();
        } else if (this.nameLookUpTable == null) {
            return false;
        }
        return this.nameLookUpTable.containsKey(string);
    }

    private HashMap makeAttrNameLookUpTable() {
        this.modCountWhenLookUpWasCreated = this.getModCount();
        int n = this.size();
        int n2 = new Float(1.35 * (double)n).intValue();
        HashMap<String, iAttribute> hashMap = new HashMap<String, iAttribute>(n2);
        int n3 = 0;
        while (n3 < n) {
            iAttribute iAttribute2 = this.getAttribute(n3);
            String string = iAttribute2.getName();
            hashMap.put(string, iAttribute2);
            ++n3;
        }
        return hashMap;
    }
}

